/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.HierarchyGroup;
import software.amazon.awssdk.services.connect.model.SearchUserHierarchyGroupsRequest;
import software.amazon.awssdk.services.connect.model.SearchUserHierarchyGroupsResponse;

public class SearchUserHierarchyGroupsIterable
implements SdkIterable<SearchUserHierarchyGroupsResponse> {
    private final ConnectClient client;
    private final SearchUserHierarchyGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchUserHierarchyGroupsIterable(ConnectClient client, SearchUserHierarchyGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchUserHierarchyGroupsResponseFetcher();
    }

    public Iterator<SearchUserHierarchyGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<HierarchyGroup> userHierarchyGroups() {
        Function<SearchUserHierarchyGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.userHierarchyGroups() != null) {
                return response.userHierarchyGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchUserHierarchyGroupsResponseFetcher
    implements SyncPageFetcher<SearchUserHierarchyGroupsResponse> {
        private SearchUserHierarchyGroupsResponseFetcher() {
        }

        public boolean hasNextPage(SearchUserHierarchyGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchUserHierarchyGroupsResponse nextPage(SearchUserHierarchyGroupsResponse previousPage) {
            if (previousPage == null) {
                return SearchUserHierarchyGroupsIterable.this.client.searchUserHierarchyGroups(SearchUserHierarchyGroupsIterable.this.firstRequest);
            }
            return SearchUserHierarchyGroupsIterable.this.client.searchUserHierarchyGroups((SearchUserHierarchyGroupsRequest)((Object)SearchUserHierarchyGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

