/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.IntervalPeriod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IntervalDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IntervalDetails> {
    private static final SdkField<String> TIME_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimeZone").getter(IntervalDetails.getter(IntervalDetails::timeZone)).setter(IntervalDetails.setter(Builder::timeZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeZone").build()}).build();
    private static final SdkField<String> INTERVAL_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IntervalPeriod").getter(IntervalDetails.getter(IntervalDetails::intervalPeriodAsString)).setter(IntervalDetails.setter(Builder::intervalPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntervalPeriod").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_ZONE_FIELD, INTERVAL_PERIOD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IntervalDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String timeZone;
    private final String intervalPeriod;

    private IntervalDetails(BuilderImpl builder) {
        this.timeZone = builder.timeZone;
        this.intervalPeriod = builder.intervalPeriod;
    }

    public final String timeZone() {
        return this.timeZone;
    }

    public final IntervalPeriod intervalPeriod() {
        return IntervalPeriod.fromValue(this.intervalPeriod);
    }

    public final String intervalPeriodAsString() {
        return this.intervalPeriod;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timeZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.intervalPeriodAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntervalDetails)) {
            return false;
        }
        IntervalDetails other = (IntervalDetails)obj;
        return Objects.equals(this.timeZone(), other.timeZone()) && Objects.equals(this.intervalPeriodAsString(), other.intervalPeriodAsString());
    }

    public final String toString() {
        return ToString.builder((String)"IntervalDetails").add("TimeZone", (Object)this.timeZone()).add("IntervalPeriod", (Object)this.intervalPeriodAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TimeZone": {
                return Optional.ofNullable(clazz.cast(this.timeZone()));
            }
            case "IntervalPeriod": {
                return Optional.ofNullable(clazz.cast(this.intervalPeriodAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("TimeZone", TIME_ZONE_FIELD);
        map.put("IntervalPeriod", INTERVAL_PERIOD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IntervalDetails, T> g) {
        return obj -> g.apply((IntervalDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String timeZone;
        private String intervalPeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(IntervalDetails model) {
            this.timeZone(model.timeZone);
            this.intervalPeriod(model.intervalPeriod);
        }

        public final String getTimeZone() {
            return this.timeZone;
        }

        public final void setTimeZone(String timeZone) {
            this.timeZone = timeZone;
        }

        @Override
        public final Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public final String getIntervalPeriod() {
            return this.intervalPeriod;
        }

        public final void setIntervalPeriod(String intervalPeriod) {
            this.intervalPeriod = intervalPeriod;
        }

        @Override
        public final Builder intervalPeriod(String intervalPeriod) {
            this.intervalPeriod = intervalPeriod;
            return this;
        }

        @Override
        public final Builder intervalPeriod(IntervalPeriod intervalPeriod) {
            this.intervalPeriod(intervalPeriod == null ? null : intervalPeriod.toString());
            return this;
        }

        public IntervalDetails build() {
            return new IntervalDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IntervalDetails> {
        public Builder timeZone(String var1);

        public Builder intervalPeriod(String var1);

        public Builder intervalPeriod(IntervalPeriod var1);
    }
}

