/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.ListContactReferencesRequest;
import software.amazon.awssdk.services.connect.model.ListContactReferencesResponse;
import software.amazon.awssdk.services.connect.model.ReferenceSummary;

public class ListContactReferencesPublisher
implements SdkPublisher<ListContactReferencesResponse> {
    private final ConnectAsyncClient client;
    private final ListContactReferencesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListContactReferencesPublisher(ConnectAsyncClient client, ListContactReferencesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListContactReferencesPublisher(ConnectAsyncClient client, ListContactReferencesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListContactReferencesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListContactReferencesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ReferenceSummary> referenceSummaryList() {
        Function<ListContactReferencesResponse, Iterator> getIterator = response -> {
            if (response != null && response.referenceSummaryList() != null) {
                return response.referenceSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListContactReferencesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListContactReferencesResponseFetcher
    implements AsyncPageFetcher<ListContactReferencesResponse> {
        private ListContactReferencesResponseFetcher() {
        }

        public boolean hasNextPage(ListContactReferencesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListContactReferencesResponse> nextPage(ListContactReferencesResponse previousPage) {
            if (previousPage == null) {
                return ListContactReferencesPublisher.this.client.listContactReferences(ListContactReferencesPublisher.this.firstRequest);
            }
            return ListContactReferencesPublisher.this.client.listContactReferences((ListContactReferencesRequest)((Object)ListContactReferencesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

