/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.AttributesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TemplateAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TemplateAttributes> {
    private static final SdkField<Map<String, String>> CUSTOM_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("CustomAttributes").getter(TemplateAttributes.getter(TemplateAttributes::customAttributes)).setter(TemplateAttributes.setter(Builder::customAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CUSTOMER_PROFILE_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomerProfileAttributes").getter(TemplateAttributes.getter(TemplateAttributes::customerProfileAttributes)).setter(TemplateAttributes.setter(Builder::customerProfileAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerProfileAttributes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_ATTRIBUTES_FIELD, CUSTOMER_PROFILE_ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TemplateAttributes.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, String> customAttributes;
    private final String customerProfileAttributes;

    private TemplateAttributes(BuilderImpl builder) {
        this.customAttributes = builder.customAttributes;
        this.customerProfileAttributes = builder.customerProfileAttributes;
    }

    public final boolean hasCustomAttributes() {
        return this.customAttributes != null && !(this.customAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> customAttributes() {
        return this.customAttributes;
    }

    public final String customerProfileAttributes() {
        return this.customerProfileAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomAttributes() ? this.customAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.customerProfileAttributes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateAttributes)) {
            return false;
        }
        TemplateAttributes other = (TemplateAttributes)obj;
        return this.hasCustomAttributes() == other.hasCustomAttributes() && Objects.equals(this.customAttributes(), other.customAttributes()) && Objects.equals(this.customerProfileAttributes(), other.customerProfileAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"TemplateAttributes").add("CustomAttributes", this.hasCustomAttributes() ? this.customAttributes() : null).add("CustomerProfileAttributes", (Object)this.customerProfileAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CustomAttributes": {
                return Optional.ofNullable(clazz.cast(this.customAttributes()));
            }
            case "CustomerProfileAttributes": {
                return Optional.ofNullable(clazz.cast(this.customerProfileAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CustomAttributes", CUSTOM_ATTRIBUTES_FIELD);
        map.put("CustomerProfileAttributes", CUSTOMER_PROFILE_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TemplateAttributes, T> g) {
        return obj -> g.apply((TemplateAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> customAttributes = DefaultSdkAutoConstructMap.getInstance();
        private String customerProfileAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateAttributes model) {
            this.customAttributes(model.customAttributes);
            this.customerProfileAttributes(model.customerProfileAttributes);
        }

        public final Map<String, String> getCustomAttributes() {
            if (this.customAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.customAttributes;
        }

        public final void setCustomAttributes(Map<String, String> customAttributes) {
            this.customAttributes = AttributesCopier.copy(customAttributes);
        }

        @Override
        public final Builder customAttributes(Map<String, String> customAttributes) {
            this.customAttributes = AttributesCopier.copy(customAttributes);
            return this;
        }

        public final String getCustomerProfileAttributes() {
            return this.customerProfileAttributes;
        }

        public final void setCustomerProfileAttributes(String customerProfileAttributes) {
            this.customerProfileAttributes = customerProfileAttributes;
        }

        @Override
        public final Builder customerProfileAttributes(String customerProfileAttributes) {
            this.customerProfileAttributes = customerProfileAttributes;
            return this;
        }

        public TemplateAttributes build() {
            return new TemplateAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TemplateAttributes> {
        public Builder customAttributes(Map<String, String> var1);

        public Builder customerProfileAttributes(String var1);
    }
}

