/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.OutboundMessageSourceType;
import software.amazon.awssdk.services.connect.model.OutboundRawMessage;
import software.amazon.awssdk.services.connect.model.TemplatedMessageConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OutboundEmailContent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OutboundEmailContent> {
    private static final SdkField<String> MESSAGE_SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageSourceType").getter(OutboundEmailContent.getter(OutboundEmailContent::messageSourceTypeAsString)).setter(OutboundEmailContent.setter(Builder::messageSourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageSourceType").build()}).build();
    private static final SdkField<TemplatedMessageConfig> TEMPLATED_MESSAGE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TemplatedMessageConfig").getter(OutboundEmailContent.getter(OutboundEmailContent::templatedMessageConfig)).setter(OutboundEmailContent.setter(Builder::templatedMessageConfig)).constructor(TemplatedMessageConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplatedMessageConfig").build()}).build();
    private static final SdkField<OutboundRawMessage> RAW_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RawMessage").getter(OutboundEmailContent.getter(OutboundEmailContent::rawMessage)).setter(OutboundEmailContent.setter(Builder::rawMessage)).constructor(OutboundRawMessage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RawMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_SOURCE_TYPE_FIELD, TEMPLATED_MESSAGE_CONFIG_FIELD, RAW_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OutboundEmailContent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String messageSourceType;
    private final TemplatedMessageConfig templatedMessageConfig;
    private final OutboundRawMessage rawMessage;

    private OutboundEmailContent(BuilderImpl builder) {
        this.messageSourceType = builder.messageSourceType;
        this.templatedMessageConfig = builder.templatedMessageConfig;
        this.rawMessage = builder.rawMessage;
    }

    public final OutboundMessageSourceType messageSourceType() {
        return OutboundMessageSourceType.fromValue(this.messageSourceType);
    }

    public final String messageSourceTypeAsString() {
        return this.messageSourceType;
    }

    public final TemplatedMessageConfig templatedMessageConfig() {
        return this.templatedMessageConfig;
    }

    public final OutboundRawMessage rawMessage() {
        return this.rawMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.messageSourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.templatedMessageConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.rawMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutboundEmailContent)) {
            return false;
        }
        OutboundEmailContent other = (OutboundEmailContent)obj;
        return Objects.equals(this.messageSourceTypeAsString(), other.messageSourceTypeAsString()) && Objects.equals(this.templatedMessageConfig(), other.templatedMessageConfig()) && Objects.equals(this.rawMessage(), other.rawMessage());
    }

    public final String toString() {
        return ToString.builder((String)"OutboundEmailContent").add("MessageSourceType", (Object)this.messageSourceTypeAsString()).add("TemplatedMessageConfig", (Object)this.templatedMessageConfig()).add("RawMessage", (Object)this.rawMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MessageSourceType": {
                return Optional.ofNullable(clazz.cast(this.messageSourceTypeAsString()));
            }
            case "TemplatedMessageConfig": {
                return Optional.ofNullable(clazz.cast(this.templatedMessageConfig()));
            }
            case "RawMessage": {
                return Optional.ofNullable(clazz.cast(this.rawMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MessageSourceType", MESSAGE_SOURCE_TYPE_FIELD);
        map.put("TemplatedMessageConfig", TEMPLATED_MESSAGE_CONFIG_FIELD);
        map.put("RawMessage", RAW_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OutboundEmailContent, T> g) {
        return obj -> g.apply((OutboundEmailContent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String messageSourceType;
        private TemplatedMessageConfig templatedMessageConfig;
        private OutboundRawMessage rawMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(OutboundEmailContent model) {
            this.messageSourceType(model.messageSourceType);
            this.templatedMessageConfig(model.templatedMessageConfig);
            this.rawMessage(model.rawMessage);
        }

        public final String getMessageSourceType() {
            return this.messageSourceType;
        }

        public final void setMessageSourceType(String messageSourceType) {
            this.messageSourceType = messageSourceType;
        }

        @Override
        public final Builder messageSourceType(String messageSourceType) {
            this.messageSourceType = messageSourceType;
            return this;
        }

        @Override
        public final Builder messageSourceType(OutboundMessageSourceType messageSourceType) {
            this.messageSourceType(messageSourceType == null ? null : messageSourceType.toString());
            return this;
        }

        public final TemplatedMessageConfig.Builder getTemplatedMessageConfig() {
            return this.templatedMessageConfig != null ? this.templatedMessageConfig.toBuilder() : null;
        }

        public final void setTemplatedMessageConfig(TemplatedMessageConfig.BuilderImpl templatedMessageConfig) {
            this.templatedMessageConfig = templatedMessageConfig != null ? templatedMessageConfig.build() : null;
        }

        @Override
        public final Builder templatedMessageConfig(TemplatedMessageConfig templatedMessageConfig) {
            this.templatedMessageConfig = templatedMessageConfig;
            return this;
        }

        public final OutboundRawMessage.Builder getRawMessage() {
            return this.rawMessage != null ? this.rawMessage.toBuilder() : null;
        }

        public final void setRawMessage(OutboundRawMessage.BuilderImpl rawMessage) {
            this.rawMessage = rawMessage != null ? rawMessage.build() : null;
        }

        @Override
        public final Builder rawMessage(OutboundRawMessage rawMessage) {
            this.rawMessage = rawMessage;
            return this;
        }

        public OutboundEmailContent build() {
            return new OutboundEmailContent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OutboundEmailContent> {
        public Builder messageSourceType(String var1);

        public Builder messageSourceType(OutboundMessageSourceType var1);

        public Builder templatedMessageConfig(TemplatedMessageConfig var1);

        default public Builder templatedMessageConfig(Consumer<TemplatedMessageConfig.Builder> templatedMessageConfig) {
            return this.templatedMessageConfig((TemplatedMessageConfig)((TemplatedMessageConfig.Builder)TemplatedMessageConfig.builder().applyMutation(templatedMessageConfig)).build());
        }

        public Builder rawMessage(OutboundRawMessage var1);

        default public Builder rawMessage(Consumer<OutboundRawMessage.Builder> rawMessage) {
            return this.rawMessage((OutboundRawMessage)((OutboundRawMessage.Builder)OutboundRawMessage.builder().applyMutation(rawMessage)).build());
        }
    }
}

