/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.DirectoryType;
import software.amazon.awssdk.services.connect.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateInstanceRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, CreateInstanceRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateInstanceRequest.getter(CreateInstanceRequest::clientToken)).setter(CreateInstanceRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> IDENTITY_MANAGEMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityManagementType").getter(CreateInstanceRequest.getter(CreateInstanceRequest::identityManagementTypeAsString)).setter(CreateInstanceRequest.setter(Builder::identityManagementType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityManagementType").build()}).build();
    private static final SdkField<String> INSTANCE_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceAlias").getter(CreateInstanceRequest.getter(CreateInstanceRequest::instanceAlias)).setter(CreateInstanceRequest.setter(Builder::instanceAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceAlias").build()}).build();
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryId").getter(CreateInstanceRequest.getter(CreateInstanceRequest::directoryId)).setter(CreateInstanceRequest.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<Boolean> INBOUND_CALLS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("InboundCallsEnabled").getter(CreateInstanceRequest.getter(CreateInstanceRequest::inboundCallsEnabled)).setter(CreateInstanceRequest.setter(Builder::inboundCallsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InboundCallsEnabled").build()}).build();
    private static final SdkField<Boolean> OUTBOUND_CALLS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("OutboundCallsEnabled").getter(CreateInstanceRequest.getter(CreateInstanceRequest::outboundCallsEnabled)).setter(CreateInstanceRequest.setter(Builder::outboundCallsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutboundCallsEnabled").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateInstanceRequest.getter(CreateInstanceRequest::tags)).setter(CreateInstanceRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, IDENTITY_MANAGEMENT_TYPE_FIELD, INSTANCE_ALIAS_FIELD, DIRECTORY_ID_FIELD, INBOUND_CALLS_ENABLED_FIELD, OUTBOUND_CALLS_ENABLED_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateInstanceRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String identityManagementType;
    private final String instanceAlias;
    private final String directoryId;
    private final Boolean inboundCallsEnabled;
    private final Boolean outboundCallsEnabled;
    private final Map<String, String> tags;

    private CreateInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.identityManagementType = builder.identityManagementType;
        this.instanceAlias = builder.instanceAlias;
        this.directoryId = builder.directoryId;
        this.inboundCallsEnabled = builder.inboundCallsEnabled;
        this.outboundCallsEnabled = builder.outboundCallsEnabled;
        this.tags = builder.tags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final DirectoryType identityManagementType() {
        return DirectoryType.fromValue(this.identityManagementType);
    }

    public final String identityManagementTypeAsString() {
        return this.identityManagementType;
    }

    public final String instanceAlias() {
        return this.instanceAlias;
    }

    public final String directoryId() {
        return this.directoryId;
    }

    public final Boolean inboundCallsEnabled() {
        return this.inboundCallsEnabled;
    }

    public final Boolean outboundCallsEnabled() {
        return this.outboundCallsEnabled;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityManagementTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.inboundCallsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.outboundCallsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInstanceRequest)) {
            return false;
        }
        CreateInstanceRequest other = (CreateInstanceRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.identityManagementTypeAsString(), other.identityManagementTypeAsString()) && Objects.equals(this.instanceAlias(), other.instanceAlias()) && Objects.equals(this.directoryId(), other.directoryId()) && Objects.equals(this.inboundCallsEnabled(), other.inboundCallsEnabled()) && Objects.equals(this.outboundCallsEnabled(), other.outboundCallsEnabled()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateInstanceRequest").add("ClientToken", (Object)this.clientToken()).add("IdentityManagementType", (Object)this.identityManagementTypeAsString()).add("InstanceAlias", (Object)(this.instanceAlias() == null ? null : "*** Sensitive Data Redacted ***")).add("DirectoryId", (Object)this.directoryId()).add("InboundCallsEnabled", (Object)this.inboundCallsEnabled()).add("OutboundCallsEnabled", (Object)this.outboundCallsEnabled()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "IdentityManagementType": {
                return Optional.ofNullable(clazz.cast(this.identityManagementTypeAsString()));
            }
            case "InstanceAlias": {
                return Optional.ofNullable(clazz.cast(this.instanceAlias()));
            }
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "InboundCallsEnabled": {
                return Optional.ofNullable(clazz.cast(this.inboundCallsEnabled()));
            }
            case "OutboundCallsEnabled": {
                return Optional.ofNullable(clazz.cast(this.outboundCallsEnabled()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("IdentityManagementType", IDENTITY_MANAGEMENT_TYPE_FIELD);
        map.put("InstanceAlias", INSTANCE_ALIAS_FIELD);
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("InboundCallsEnabled", INBOUND_CALLS_ENABLED_FIELD);
        map.put("OutboundCallsEnabled", OUTBOUND_CALLS_ENABLED_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateInstanceRequest, T> g) {
        return obj -> g.apply((CreateInstanceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String identityManagementType;
        private String instanceAlias;
        private String directoryId;
        private Boolean inboundCallsEnabled;
        private Boolean outboundCallsEnabled;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInstanceRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.identityManagementType(model.identityManagementType);
            this.instanceAlias(model.instanceAlias);
            this.directoryId(model.directoryId);
            this.inboundCallsEnabled(model.inboundCallsEnabled);
            this.outboundCallsEnabled(model.outboundCallsEnabled);
            this.tags(model.tags);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getIdentityManagementType() {
            return this.identityManagementType;
        }

        public final void setIdentityManagementType(String identityManagementType) {
            this.identityManagementType = identityManagementType;
        }

        @Override
        public final Builder identityManagementType(String identityManagementType) {
            this.identityManagementType = identityManagementType;
            return this;
        }

        @Override
        public final Builder identityManagementType(DirectoryType identityManagementType) {
            this.identityManagementType(identityManagementType == null ? null : identityManagementType.toString());
            return this;
        }

        public final String getInstanceAlias() {
            return this.instanceAlias;
        }

        public final void setInstanceAlias(String instanceAlias) {
            this.instanceAlias = instanceAlias;
        }

        @Override
        public final Builder instanceAlias(String instanceAlias) {
            this.instanceAlias = instanceAlias;
            return this;
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final Boolean getInboundCallsEnabled() {
            return this.inboundCallsEnabled;
        }

        public final void setInboundCallsEnabled(Boolean inboundCallsEnabled) {
            this.inboundCallsEnabled = inboundCallsEnabled;
        }

        @Override
        public final Builder inboundCallsEnabled(Boolean inboundCallsEnabled) {
            this.inboundCallsEnabled = inboundCallsEnabled;
            return this;
        }

        public final Boolean getOutboundCallsEnabled() {
            return this.outboundCallsEnabled;
        }

        public final void setOutboundCallsEnabled(Boolean outboundCallsEnabled) {
            this.outboundCallsEnabled = outboundCallsEnabled;
        }

        @Override
        public final Builder outboundCallsEnabled(Boolean outboundCallsEnabled) {
            this.outboundCallsEnabled = outboundCallsEnabled;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateInstanceRequest build() {
            return new CreateInstanceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateInstanceRequest> {
        public Builder clientToken(String var1);

        public Builder identityManagementType(String var1);

        public Builder identityManagementType(DirectoryType var1);

        public Builder instanceAlias(String var1);

        public Builder directoryId(String var1);

        public Builder inboundCallsEnabled(Boolean var1);

        public Builder outboundCallsEnabled(Boolean var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

