/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.EmailAddressSearchCriteria;
import software.amazon.awssdk.services.connect.model.EmailAddressSearchFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchEmailAddressesRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, SearchEmailAddressesRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(SearchEmailAddressesRequest.getter(SearchEmailAddressesRequest::instanceId)).setter(SearchEmailAddressesRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(SearchEmailAddressesRequest.getter(SearchEmailAddressesRequest::maxResults)).setter(SearchEmailAddressesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SearchEmailAddressesRequest.getter(SearchEmailAddressesRequest::nextToken)).setter(SearchEmailAddressesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<EmailAddressSearchCriteria> SEARCH_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SearchCriteria").getter(SearchEmailAddressesRequest.getter(SearchEmailAddressesRequest::searchCriteria)).setter(SearchEmailAddressesRequest.setter(Builder::searchCriteria)).constructor(EmailAddressSearchCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchCriteria").build()}).build();
    private static final SdkField<EmailAddressSearchFilter> SEARCH_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SearchFilter").getter(SearchEmailAddressesRequest.getter(SearchEmailAddressesRequest::searchFilter)).setter(SearchEmailAddressesRequest.setter(Builder::searchFilter)).constructor(EmailAddressSearchFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchFilter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SEARCH_CRITERIA_FIELD, SEARCH_FILTER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchEmailAddressesRequest.memberNameToFieldInitializer();
    private final String instanceId;
    private final Integer maxResults;
    private final String nextToken;
    private final EmailAddressSearchCriteria searchCriteria;
    private final EmailAddressSearchFilter searchFilter;

    private SearchEmailAddressesRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.searchCriteria = builder.searchCriteria;
        this.searchFilter = builder.searchFilter;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final EmailAddressSearchCriteria searchCriteria() {
        return this.searchCriteria;
    }

    public final EmailAddressSearchFilter searchFilter() {
        return this.searchFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchFilter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchEmailAddressesRequest)) {
            return false;
        }
        SearchEmailAddressesRequest other = (SearchEmailAddressesRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.searchCriteria(), other.searchCriteria()) && Objects.equals(this.searchFilter(), other.searchFilter());
    }

    public final String toString() {
        return ToString.builder((String)"SearchEmailAddressesRequest").add("InstanceId", (Object)this.instanceId()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("SearchCriteria", (Object)this.searchCriteria()).add("SearchFilter", (Object)this.searchFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "SearchCriteria": {
                return Optional.ofNullable(clazz.cast(this.searchCriteria()));
            }
            case "SearchFilter": {
                return Optional.ofNullable(clazz.cast(this.searchFilter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("SearchCriteria", SEARCH_CRITERIA_FIELD);
        map.put("SearchFilter", SEARCH_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchEmailAddressesRequest, T> g) {
        return obj -> g.apply((SearchEmailAddressesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private Integer maxResults;
        private String nextToken;
        private EmailAddressSearchCriteria searchCriteria;
        private EmailAddressSearchFilter searchFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchEmailAddressesRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.searchCriteria(model.searchCriteria);
            this.searchFilter(model.searchFilter);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final EmailAddressSearchCriteria.Builder getSearchCriteria() {
            return this.searchCriteria != null ? this.searchCriteria.toBuilder() : null;
        }

        public final void setSearchCriteria(EmailAddressSearchCriteria.BuilderImpl searchCriteria) {
            this.searchCriteria = searchCriteria != null ? searchCriteria.build() : null;
        }

        @Override
        public final Builder searchCriteria(EmailAddressSearchCriteria searchCriteria) {
            this.searchCriteria = searchCriteria;
            return this;
        }

        public final EmailAddressSearchFilter.Builder getSearchFilter() {
            return this.searchFilter != null ? this.searchFilter.toBuilder() : null;
        }

        public final void setSearchFilter(EmailAddressSearchFilter.BuilderImpl searchFilter) {
            this.searchFilter = searchFilter != null ? searchFilter.build() : null;
        }

        @Override
        public final Builder searchFilter(EmailAddressSearchFilter searchFilter) {
            this.searchFilter = searchFilter;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchEmailAddressesRequest build() {
            return new SearchEmailAddressesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchEmailAddressesRequest> {
        public Builder instanceId(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder searchCriteria(EmailAddressSearchCriteria var1);

        default public Builder searchCriteria(Consumer<EmailAddressSearchCriteria.Builder> searchCriteria) {
            return this.searchCriteria((EmailAddressSearchCriteria)((EmailAddressSearchCriteria.Builder)EmailAddressSearchCriteria.builder().applyMutation(searchCriteria)).build());
        }

        public Builder searchFilter(EmailAddressSearchFilter var1);

        default public Builder searchFilter(Consumer<EmailAddressSearchFilter.Builder> searchFilter) {
            return this.searchFilter((EmailAddressSearchFilter)((EmailAddressSearchFilter.Builder)EmailAddressSearchFilter.builder().applyMutation(searchFilter)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

