/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SortableFieldName {
    INITIATION_TIMESTAMP("INITIATION_TIMESTAMP"),
    SCHEDULED_TIMESTAMP("SCHEDULED_TIMESTAMP"),
    CONNECTED_TO_AGENT_TIMESTAMP("CONNECTED_TO_AGENT_TIMESTAMP"),
    DISCONNECT_TIMESTAMP("DISCONNECT_TIMESTAMP"),
    INITIATION_METHOD("INITIATION_METHOD"),
    CHANNEL("CHANNEL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SortableFieldName> VALUE_MAP;
    private final String value;

    private SortableFieldName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SortableFieldName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SortableFieldName> knownValues() {
        EnumSet<SortableFieldName> knownValues = EnumSet.allOf(SortableFieldName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SortableFieldName.class, SortableFieldName::toString);
    }
}

