/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ContactRecordingType {
    AGENT("AGENT"),
    IVR("IVR"),
    SCREEN("SCREEN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ContactRecordingType> VALUE_MAP;
    private final String value;

    private ContactRecordingType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ContactRecordingType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ContactRecordingType> knownValues() {
        EnumSet<ContactRecordingType> knownValues = EnumSet.allOf(ContactRecordingType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ContactRecordingType.class, ContactRecordingType::toString);
    }
}

