/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.NotificationContentType;
import software.amazon.awssdk.services.connect.model.NotificationDeliveryType;
import software.amazon.awssdk.services.connect.model.NotificationRecipientType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendNotificationActionDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SendNotificationActionDefinition> {
    private static final SdkField<String> DELIVERY_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeliveryMethod").getter(SendNotificationActionDefinition.getter(SendNotificationActionDefinition::deliveryMethodAsString)).setter(SendNotificationActionDefinition.setter(Builder::deliveryMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryMethod").build()}).build();
    private static final SdkField<String> SUBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Subject").getter(SendNotificationActionDefinition.getter(SendNotificationActionDefinition::subject)).setter(SendNotificationActionDefinition.setter(Builder::subject)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subject").build()}).build();
    private static final SdkField<String> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Content").getter(SendNotificationActionDefinition.getter(SendNotificationActionDefinition::content)).setter(SendNotificationActionDefinition.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentType").getter(SendNotificationActionDefinition.getter(SendNotificationActionDefinition::contentTypeAsString)).setter(SendNotificationActionDefinition.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").build()}).build();
    private static final SdkField<NotificationRecipientType> RECIPIENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Recipient").getter(SendNotificationActionDefinition.getter(SendNotificationActionDefinition::recipient)).setter(SendNotificationActionDefinition.setter(Builder::recipient)).constructor(NotificationRecipientType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recipient").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_METHOD_FIELD, SUBJECT_FIELD, CONTENT_FIELD, CONTENT_TYPE_FIELD, RECIPIENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SendNotificationActionDefinition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String deliveryMethod;
    private final String subject;
    private final String content;
    private final String contentType;
    private final NotificationRecipientType recipient;

    private SendNotificationActionDefinition(BuilderImpl builder) {
        this.deliveryMethod = builder.deliveryMethod;
        this.subject = builder.subject;
        this.content = builder.content;
        this.contentType = builder.contentType;
        this.recipient = builder.recipient;
    }

    public final NotificationDeliveryType deliveryMethod() {
        return NotificationDeliveryType.fromValue(this.deliveryMethod);
    }

    public final String deliveryMethodAsString() {
        return this.deliveryMethod;
    }

    public final String subject() {
        return this.subject;
    }

    public final String content() {
        return this.content;
    }

    public final NotificationContentType contentType() {
        return NotificationContentType.fromValue(this.contentType);
    }

    public final String contentTypeAsString() {
        return this.contentType;
    }

    public final NotificationRecipientType recipient() {
        return this.recipient;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.subject());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.recipient());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendNotificationActionDefinition)) {
            return false;
        }
        SendNotificationActionDefinition other = (SendNotificationActionDefinition)obj;
        return Objects.equals(this.deliveryMethodAsString(), other.deliveryMethodAsString()) && Objects.equals(this.subject(), other.subject()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.contentTypeAsString(), other.contentTypeAsString()) && Objects.equals(this.recipient(), other.recipient());
    }

    public final String toString() {
        return ToString.builder((String)"SendNotificationActionDefinition").add("DeliveryMethod", (Object)this.deliveryMethodAsString()).add("Subject", (Object)this.subject()).add("Content", (Object)this.content()).add("ContentType", (Object)this.contentTypeAsString()).add("Recipient", (Object)this.recipient()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeliveryMethod": {
                return Optional.ofNullable(clazz.cast(this.deliveryMethodAsString()));
            }
            case "Subject": {
                return Optional.ofNullable(clazz.cast(this.subject()));
            }
            case "Content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "ContentType": {
                return Optional.ofNullable(clazz.cast(this.contentTypeAsString()));
            }
            case "Recipient": {
                return Optional.ofNullable(clazz.cast(this.recipient()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DeliveryMethod", DELIVERY_METHOD_FIELD);
        map.put("Subject", SUBJECT_FIELD);
        map.put("Content", CONTENT_FIELD);
        map.put("ContentType", CONTENT_TYPE_FIELD);
        map.put("Recipient", RECIPIENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SendNotificationActionDefinition, T> g) {
        return obj -> g.apply((SendNotificationActionDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deliveryMethod;
        private String subject;
        private String content;
        private String contentType;
        private NotificationRecipientType recipient;

        private BuilderImpl() {
        }

        private BuilderImpl(SendNotificationActionDefinition model) {
            this.deliveryMethod(model.deliveryMethod);
            this.subject(model.subject);
            this.content(model.content);
            this.contentType(model.contentType);
            this.recipient(model.recipient);
        }

        public final String getDeliveryMethod() {
            return this.deliveryMethod;
        }

        public final void setDeliveryMethod(String deliveryMethod) {
            this.deliveryMethod = deliveryMethod;
        }

        @Override
        public final Builder deliveryMethod(String deliveryMethod) {
            this.deliveryMethod = deliveryMethod;
            return this;
        }

        @Override
        public final Builder deliveryMethod(NotificationDeliveryType deliveryMethod) {
            this.deliveryMethod(deliveryMethod == null ? null : deliveryMethod.toString());
            return this;
        }

        public final String getSubject() {
            return this.subject;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final String getContent() {
            return this.content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public final Builder contentType(NotificationContentType contentType) {
            this.contentType(contentType == null ? null : contentType.toString());
            return this;
        }

        public final NotificationRecipientType.Builder getRecipient() {
            return this.recipient != null ? this.recipient.toBuilder() : null;
        }

        public final void setRecipient(NotificationRecipientType.BuilderImpl recipient) {
            this.recipient = recipient != null ? recipient.build() : null;
        }

        @Override
        public final Builder recipient(NotificationRecipientType recipient) {
            this.recipient = recipient;
            return this;
        }

        public SendNotificationActionDefinition build() {
            return new SendNotificationActionDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SendNotificationActionDefinition> {
        public Builder deliveryMethod(String var1);

        public Builder deliveryMethod(NotificationDeliveryType var1);

        public Builder subject(String var1);

        public Builder content(String var1);

        public Builder contentType(String var1);

        public Builder contentType(NotificationContentType var1);

        public Builder recipient(NotificationRecipientType var1);

        default public Builder recipient(Consumer<NotificationRecipientType.Builder> recipient) {
            return this.recipient((NotificationRecipientType)((NotificationRecipientType.Builder)NotificationRecipientType.builder().applyMutation(recipient)).build());
        }
    }
}

