/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.HierarchyGroup;
import software.amazon.awssdk.services.connect.model.UserHierarchyGroupListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchUserHierarchyGroupsResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, SearchUserHierarchyGroupsResponse> {
    private static final SdkField<List<HierarchyGroup>> USER_HIERARCHY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserHierarchyGroups").getter(SearchUserHierarchyGroupsResponse.getter(SearchUserHierarchyGroupsResponse::userHierarchyGroups)).setter(SearchUserHierarchyGroupsResponse.setter(Builder::userHierarchyGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserHierarchyGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HierarchyGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SearchUserHierarchyGroupsResponse.getter(SearchUserHierarchyGroupsResponse::nextToken)).setter(SearchUserHierarchyGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Long> APPROXIMATE_TOTAL_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ApproximateTotalCount").getter(SearchUserHierarchyGroupsResponse.getter(SearchUserHierarchyGroupsResponse::approximateTotalCount)).setter(SearchUserHierarchyGroupsResponse.setter(Builder::approximateTotalCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproximateTotalCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_HIERARCHY_GROUPS_FIELD, NEXT_TOKEN_FIELD, APPROXIMATE_TOTAL_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchUserHierarchyGroupsResponse.memberNameToFieldInitializer();
    private final List<HierarchyGroup> userHierarchyGroups;
    private final String nextToken;
    private final Long approximateTotalCount;

    private SearchUserHierarchyGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.userHierarchyGroups = builder.userHierarchyGroups;
        this.nextToken = builder.nextToken;
        this.approximateTotalCount = builder.approximateTotalCount;
    }

    public final boolean hasUserHierarchyGroups() {
        return this.userHierarchyGroups != null && !(this.userHierarchyGroups instanceof SdkAutoConstructList);
    }

    public final List<HierarchyGroup> userHierarchyGroups() {
        return this.userHierarchyGroups;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Long approximateTotalCount() {
        return this.approximateTotalCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserHierarchyGroups() ? this.userHierarchyGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.approximateTotalCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchUserHierarchyGroupsResponse)) {
            return false;
        }
        SearchUserHierarchyGroupsResponse other = (SearchUserHierarchyGroupsResponse)((Object)obj);
        return this.hasUserHierarchyGroups() == other.hasUserHierarchyGroups() && Objects.equals(this.userHierarchyGroups(), other.userHierarchyGroups()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.approximateTotalCount(), other.approximateTotalCount());
    }

    public final String toString() {
        return ToString.builder((String)"SearchUserHierarchyGroupsResponse").add("UserHierarchyGroups", this.hasUserHierarchyGroups() ? this.userHierarchyGroups() : null).add("NextToken", (Object)this.nextToken()).add("ApproximateTotalCount", (Object)this.approximateTotalCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserHierarchyGroups": {
                return Optional.ofNullable(clazz.cast(this.userHierarchyGroups()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ApproximateTotalCount": {
                return Optional.ofNullable(clazz.cast(this.approximateTotalCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("UserHierarchyGroups", USER_HIERARCHY_GROUPS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("ApproximateTotalCount", APPROXIMATE_TOTAL_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchUserHierarchyGroupsResponse, T> g) {
        return obj -> g.apply((SearchUserHierarchyGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<HierarchyGroup> userHierarchyGroups = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Long approximateTotalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchUserHierarchyGroupsResponse model) {
            super(model);
            this.userHierarchyGroups(model.userHierarchyGroups);
            this.nextToken(model.nextToken);
            this.approximateTotalCount(model.approximateTotalCount);
        }

        public final List<HierarchyGroup.Builder> getUserHierarchyGroups() {
            List<HierarchyGroup.Builder> result = UserHierarchyGroupListCopier.copyToBuilder(this.userHierarchyGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserHierarchyGroups(Collection<HierarchyGroup.BuilderImpl> userHierarchyGroups) {
            this.userHierarchyGroups = UserHierarchyGroupListCopier.copyFromBuilder(userHierarchyGroups);
        }

        @Override
        public final Builder userHierarchyGroups(Collection<HierarchyGroup> userHierarchyGroups) {
            this.userHierarchyGroups = UserHierarchyGroupListCopier.copy(userHierarchyGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userHierarchyGroups(HierarchyGroup ... userHierarchyGroups) {
            this.userHierarchyGroups(Arrays.asList(userHierarchyGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userHierarchyGroups(Consumer<HierarchyGroup.Builder> ... userHierarchyGroups) {
            this.userHierarchyGroups(Stream.of(userHierarchyGroups).map(c -> (HierarchyGroup)((HierarchyGroup.Builder)HierarchyGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Long getApproximateTotalCount() {
            return this.approximateTotalCount;
        }

        public final void setApproximateTotalCount(Long approximateTotalCount) {
            this.approximateTotalCount = approximateTotalCount;
        }

        @Override
        public final Builder approximateTotalCount(Long approximateTotalCount) {
            this.approximateTotalCount = approximateTotalCount;
            return this;
        }

        @Override
        public SearchUserHierarchyGroupsResponse build() {
            return new SearchUserHierarchyGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchUserHierarchyGroupsResponse> {
        public Builder userHierarchyGroups(Collection<HierarchyGroup> var1);

        public Builder userHierarchyGroups(HierarchyGroup ... var1);

        public Builder userHierarchyGroups(Consumer<HierarchyGroup.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder approximateTotalCount(Long var1);
    }
}

