/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.RealTimeContactAnalysisOutputType;
import software.amazon.awssdk.services.connect.model.RealTimeContactAnalysisSegmentType;
import software.amazon.awssdk.services.connect.model.RealTimeContactAnalysisSegmentTypesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRealtimeContactAnalysisSegmentsV2Request
extends ConnectRequest
implements ToCopyableBuilder<Builder, ListRealtimeContactAnalysisSegmentsV2Request> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(ListRealtimeContactAnalysisSegmentsV2Request.getter(ListRealtimeContactAnalysisSegmentsV2Request::instanceId)).setter(ListRealtimeContactAnalysisSegmentsV2Request.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactId").getter(ListRealtimeContactAnalysisSegmentsV2Request.getter(ListRealtimeContactAnalysisSegmentsV2Request::contactId)).setter(ListRealtimeContactAnalysisSegmentsV2Request.setter(Builder::contactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ContactId").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListRealtimeContactAnalysisSegmentsV2Request.getter(ListRealtimeContactAnalysisSegmentsV2Request::maxResults)).setter(ListRealtimeContactAnalysisSegmentsV2Request.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRealtimeContactAnalysisSegmentsV2Request.getter(ListRealtimeContactAnalysisSegmentsV2Request::nextToken)).setter(ListRealtimeContactAnalysisSegmentsV2Request.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> OUTPUT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputType").getter(ListRealtimeContactAnalysisSegmentsV2Request.getter(ListRealtimeContactAnalysisSegmentsV2Request::outputTypeAsString)).setter(ListRealtimeContactAnalysisSegmentsV2Request.setter(Builder::outputType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputType").build()}).build();
    private static final SdkField<List<String>> SEGMENT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SegmentTypes").getter(ListRealtimeContactAnalysisSegmentsV2Request.getter(ListRealtimeContactAnalysisSegmentsV2Request::segmentTypesAsStrings)).setter(ListRealtimeContactAnalysisSegmentsV2Request.setter(Builder::segmentTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, CONTACT_ID_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, OUTPUT_TYPE_FIELD, SEGMENT_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListRealtimeContactAnalysisSegmentsV2Request.memberNameToFieldInitializer();
    private final String instanceId;
    private final String contactId;
    private final Integer maxResults;
    private final String nextToken;
    private final String outputType;
    private final List<String> segmentTypes;

    private ListRealtimeContactAnalysisSegmentsV2Request(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.contactId = builder.contactId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.outputType = builder.outputType;
        this.segmentTypes = builder.segmentTypes;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String contactId() {
        return this.contactId;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final RealTimeContactAnalysisOutputType outputType() {
        return RealTimeContactAnalysisOutputType.fromValue(this.outputType);
    }

    public final String outputTypeAsString() {
        return this.outputType;
    }

    public final List<RealTimeContactAnalysisSegmentType> segmentTypes() {
        return RealTimeContactAnalysisSegmentTypesCopier.copyStringToEnum(this.segmentTypes);
    }

    public final boolean hasSegmentTypes() {
        return this.segmentTypes != null && !(this.segmentTypes instanceof SdkAutoConstructList);
    }

    public final List<String> segmentTypesAsStrings() {
        return this.segmentTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSegmentTypes() ? this.segmentTypesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRealtimeContactAnalysisSegmentsV2Request)) {
            return false;
        }
        ListRealtimeContactAnalysisSegmentsV2Request other = (ListRealtimeContactAnalysisSegmentsV2Request)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.contactId(), other.contactId()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.outputTypeAsString(), other.outputTypeAsString()) && this.hasSegmentTypes() == other.hasSegmentTypes() && Objects.equals(this.segmentTypesAsStrings(), other.segmentTypesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ListRealtimeContactAnalysisSegmentsV2Request").add("InstanceId", (Object)this.instanceId()).add("ContactId", (Object)this.contactId()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("OutputType", (Object)this.outputTypeAsString()).add("SegmentTypes", this.hasSegmentTypes() ? this.segmentTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "ContactId": {
                return Optional.ofNullable(clazz.cast(this.contactId()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "OutputType": {
                return Optional.ofNullable(clazz.cast(this.outputTypeAsString()));
            }
            case "SegmentTypes": {
                return Optional.ofNullable(clazz.cast(this.segmentTypesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("ContactId", CONTACT_ID_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("OutputType", OUTPUT_TYPE_FIELD);
        map.put("SegmentTypes", SEGMENT_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRealtimeContactAnalysisSegmentsV2Request, T> g) {
        return obj -> g.apply((ListRealtimeContactAnalysisSegmentsV2Request)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String contactId;
        private Integer maxResults;
        private String nextToken;
        private String outputType;
        private List<String> segmentTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRealtimeContactAnalysisSegmentsV2Request model) {
            super(model);
            this.instanceId(model.instanceId);
            this.contactId(model.contactId);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.outputType(model.outputType);
            this.segmentTypesWithStrings(model.segmentTypes);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getContactId() {
            return this.contactId;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        @Override
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getOutputType() {
            return this.outputType;
        }

        public final void setOutputType(String outputType) {
            this.outputType = outputType;
        }

        @Override
        public final Builder outputType(String outputType) {
            this.outputType = outputType;
            return this;
        }

        @Override
        public final Builder outputType(RealTimeContactAnalysisOutputType outputType) {
            this.outputType(outputType == null ? null : outputType.toString());
            return this;
        }

        public final Collection<String> getSegmentTypes() {
            if (this.segmentTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.segmentTypes;
        }

        public final void setSegmentTypes(Collection<String> segmentTypes) {
            this.segmentTypes = RealTimeContactAnalysisSegmentTypesCopier.copy(segmentTypes);
        }

        @Override
        public final Builder segmentTypesWithStrings(Collection<String> segmentTypes) {
            this.segmentTypes = RealTimeContactAnalysisSegmentTypesCopier.copy(segmentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segmentTypesWithStrings(String ... segmentTypes) {
            this.segmentTypesWithStrings(Arrays.asList(segmentTypes));
            return this;
        }

        @Override
        public final Builder segmentTypes(Collection<RealTimeContactAnalysisSegmentType> segmentTypes) {
            this.segmentTypes = RealTimeContactAnalysisSegmentTypesCopier.copyEnumToString(segmentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segmentTypes(RealTimeContactAnalysisSegmentType ... segmentTypes) {
            this.segmentTypes(Arrays.asList(segmentTypes));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRealtimeContactAnalysisSegmentsV2Request build() {
            return new ListRealtimeContactAnalysisSegmentsV2Request(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRealtimeContactAnalysisSegmentsV2Request> {
        public Builder instanceId(String var1);

        public Builder contactId(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder outputType(String var1);

        public Builder outputType(RealTimeContactAnalysisOutputType var1);

        public Builder segmentTypesWithStrings(Collection<String> var1);

        public Builder segmentTypesWithStrings(String ... var1);

        public Builder segmentTypes(Collection<RealTimeContactAnalysisSegmentType> var1);

        public Builder segmentTypes(RealTimeContactAnalysisSegmentType ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

