/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.SecurityProfileIdsCopier;
import software.amazon.awssdk.services.connect.model.TagMapCopier;
import software.amazon.awssdk.services.connect.model.UserIdentityInfoLite;
import software.amazon.awssdk.services.connect.model.UserPhoneConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserSearchSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserSearchSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(UserSearchSummary.getter(UserSearchSummary::arn)).setter(UserSearchSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> DIRECTORY_USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryUserId").getter(UserSearchSummary.getter(UserSearchSummary::directoryUserId)).setter(UserSearchSummary.setter(Builder::directoryUserId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryUserId").build()}).build();
    private static final SdkField<String> HIERARCHY_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HierarchyGroupId").getter(UserSearchSummary.getter(UserSearchSummary::hierarchyGroupId)).setter(UserSearchSummary.setter(Builder::hierarchyGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HierarchyGroupId").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(UserSearchSummary.getter(UserSearchSummary::id)).setter(UserSearchSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<UserIdentityInfoLite> IDENTITY_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IdentityInfo").getter(UserSearchSummary.getter(UserSearchSummary::identityInfo)).setter(UserSearchSummary.setter(Builder::identityInfo)).constructor(UserIdentityInfoLite::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityInfo").build()}).build();
    private static final SdkField<UserPhoneConfig> PHONE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PhoneConfig").getter(UserSearchSummary.getter(UserSearchSummary::phoneConfig)).setter(UserSearchSummary.setter(Builder::phoneConfig)).constructor(UserPhoneConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneConfig").build()}).build();
    private static final SdkField<String> ROUTING_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoutingProfileId").getter(UserSearchSummary.getter(UserSearchSummary::routingProfileId)).setter(UserSearchSummary.setter(Builder::routingProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingProfileId").build()}).build();
    private static final SdkField<List<String>> SECURITY_PROFILE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityProfileIds").getter(UserSearchSummary.getter(UserSearchSummary::securityProfileIds)).setter(UserSearchSummary.setter(Builder::securityProfileIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityProfileIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(UserSearchSummary.getter(UserSearchSummary::tags)).setter(UserSearchSummary.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Username").getter(UserSearchSummary.getter(UserSearchSummary::username)).setter(UserSearchSummary.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, DIRECTORY_USER_ID_FIELD, HIERARCHY_GROUP_ID_FIELD, ID_FIELD, IDENTITY_INFO_FIELD, PHONE_CONFIG_FIELD, ROUTING_PROFILE_ID_FIELD, SECURITY_PROFILE_IDS_FIELD, TAGS_FIELD, USERNAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UserSearchSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String directoryUserId;
    private final String hierarchyGroupId;
    private final String id;
    private final UserIdentityInfoLite identityInfo;
    private final UserPhoneConfig phoneConfig;
    private final String routingProfileId;
    private final List<String> securityProfileIds;
    private final Map<String, String> tags;
    private final String username;

    private UserSearchSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.directoryUserId = builder.directoryUserId;
        this.hierarchyGroupId = builder.hierarchyGroupId;
        this.id = builder.id;
        this.identityInfo = builder.identityInfo;
        this.phoneConfig = builder.phoneConfig;
        this.routingProfileId = builder.routingProfileId;
        this.securityProfileIds = builder.securityProfileIds;
        this.tags = builder.tags;
        this.username = builder.username;
    }

    public final String arn() {
        return this.arn;
    }

    public final String directoryUserId() {
        return this.directoryUserId;
    }

    public final String hierarchyGroupId() {
        return this.hierarchyGroupId;
    }

    public final String id() {
        return this.id;
    }

    public final UserIdentityInfoLite identityInfo() {
        return this.identityInfo;
    }

    public final UserPhoneConfig phoneConfig() {
        return this.phoneConfig;
    }

    public final String routingProfileId() {
        return this.routingProfileId;
    }

    public final boolean hasSecurityProfileIds() {
        return this.securityProfileIds != null && !(this.securityProfileIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityProfileIds() {
        return this.securityProfileIds;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String username() {
        return this.username;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryUserId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hierarchyGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityProfileIds() ? this.securityProfileIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserSearchSummary)) {
            return false;
        }
        UserSearchSummary other = (UserSearchSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.directoryUserId(), other.directoryUserId()) && Objects.equals(this.hierarchyGroupId(), other.hierarchyGroupId()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.identityInfo(), other.identityInfo()) && Objects.equals(this.phoneConfig(), other.phoneConfig()) && Objects.equals(this.routingProfileId(), other.routingProfileId()) && this.hasSecurityProfileIds() == other.hasSecurityProfileIds() && Objects.equals(this.securityProfileIds(), other.securityProfileIds()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.username(), other.username());
    }

    public final String toString() {
        return ToString.builder((String)"UserSearchSummary").add("Arn", (Object)this.arn()).add("DirectoryUserId", (Object)this.directoryUserId()).add("HierarchyGroupId", (Object)this.hierarchyGroupId()).add("Id", (Object)this.id()).add("IdentityInfo", (Object)this.identityInfo()).add("PhoneConfig", (Object)this.phoneConfig()).add("RoutingProfileId", (Object)this.routingProfileId()).add("SecurityProfileIds", this.hasSecurityProfileIds() ? this.securityProfileIds() : null).add("Tags", this.hasTags() ? this.tags() : null).add("Username", (Object)this.username()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "DirectoryUserId": {
                return Optional.ofNullable(clazz.cast(this.directoryUserId()));
            }
            case "HierarchyGroupId": {
                return Optional.ofNullable(clazz.cast(this.hierarchyGroupId()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "IdentityInfo": {
                return Optional.ofNullable(clazz.cast(this.identityInfo()));
            }
            case "PhoneConfig": {
                return Optional.ofNullable(clazz.cast(this.phoneConfig()));
            }
            case "RoutingProfileId": {
                return Optional.ofNullable(clazz.cast(this.routingProfileId()));
            }
            case "SecurityProfileIds": {
                return Optional.ofNullable(clazz.cast(this.securityProfileIds()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("DirectoryUserId", DIRECTORY_USER_ID_FIELD);
        map.put("HierarchyGroupId", HIERARCHY_GROUP_ID_FIELD);
        map.put("Id", ID_FIELD);
        map.put("IdentityInfo", IDENTITY_INFO_FIELD);
        map.put("PhoneConfig", PHONE_CONFIG_FIELD);
        map.put("RoutingProfileId", ROUTING_PROFILE_ID_FIELD);
        map.put("SecurityProfileIds", SECURITY_PROFILE_IDS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("Username", USERNAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UserSearchSummary, T> g) {
        return obj -> g.apply((UserSearchSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String directoryUserId;
        private String hierarchyGroupId;
        private String id;
        private UserIdentityInfoLite identityInfo;
        private UserPhoneConfig phoneConfig;
        private String routingProfileId;
        private List<String> securityProfileIds = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String username;

        private BuilderImpl() {
        }

        private BuilderImpl(UserSearchSummary model) {
            this.arn(model.arn);
            this.directoryUserId(model.directoryUserId);
            this.hierarchyGroupId(model.hierarchyGroupId);
            this.id(model.id);
            this.identityInfo(model.identityInfo);
            this.phoneConfig(model.phoneConfig);
            this.routingProfileId(model.routingProfileId);
            this.securityProfileIds(model.securityProfileIds);
            this.tags(model.tags);
            this.username(model.username);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDirectoryUserId() {
            return this.directoryUserId;
        }

        public final void setDirectoryUserId(String directoryUserId) {
            this.directoryUserId = directoryUserId;
        }

        @Override
        public final Builder directoryUserId(String directoryUserId) {
            this.directoryUserId = directoryUserId;
            return this;
        }

        public final String getHierarchyGroupId() {
            return this.hierarchyGroupId;
        }

        public final void setHierarchyGroupId(String hierarchyGroupId) {
            this.hierarchyGroupId = hierarchyGroupId;
        }

        @Override
        public final Builder hierarchyGroupId(String hierarchyGroupId) {
            this.hierarchyGroupId = hierarchyGroupId;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final UserIdentityInfoLite.Builder getIdentityInfo() {
            return this.identityInfo != null ? this.identityInfo.toBuilder() : null;
        }

        public final void setIdentityInfo(UserIdentityInfoLite.BuilderImpl identityInfo) {
            this.identityInfo = identityInfo != null ? identityInfo.build() : null;
        }

        @Override
        public final Builder identityInfo(UserIdentityInfoLite identityInfo) {
            this.identityInfo = identityInfo;
            return this;
        }

        public final UserPhoneConfig.Builder getPhoneConfig() {
            return this.phoneConfig != null ? this.phoneConfig.toBuilder() : null;
        }

        public final void setPhoneConfig(UserPhoneConfig.BuilderImpl phoneConfig) {
            this.phoneConfig = phoneConfig != null ? phoneConfig.build() : null;
        }

        @Override
        public final Builder phoneConfig(UserPhoneConfig phoneConfig) {
            this.phoneConfig = phoneConfig;
            return this;
        }

        public final String getRoutingProfileId() {
            return this.routingProfileId;
        }

        public final void setRoutingProfileId(String routingProfileId) {
            this.routingProfileId = routingProfileId;
        }

        @Override
        public final Builder routingProfileId(String routingProfileId) {
            this.routingProfileId = routingProfileId;
            return this;
        }

        public final Collection<String> getSecurityProfileIds() {
            if (this.securityProfileIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityProfileIds;
        }

        public final void setSecurityProfileIds(Collection<String> securityProfileIds) {
            this.securityProfileIds = SecurityProfileIdsCopier.copy(securityProfileIds);
        }

        @Override
        public final Builder securityProfileIds(Collection<String> securityProfileIds) {
            this.securityProfileIds = SecurityProfileIdsCopier.copy(securityProfileIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityProfileIds(String ... securityProfileIds) {
            this.securityProfileIds(Arrays.asList(securityProfileIds));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getUsername() {
            return this.username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public UserSearchSummary build() {
            return new UserSearchSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserSearchSummary> {
        public Builder arn(String var1);

        public Builder directoryUserId(String var1);

        public Builder hierarchyGroupId(String var1);

        public Builder id(String var1);

        public Builder identityInfo(UserIdentityInfoLite var1);

        default public Builder identityInfo(Consumer<UserIdentityInfoLite.Builder> identityInfo) {
            return this.identityInfo((UserIdentityInfoLite)((UserIdentityInfoLite.Builder)UserIdentityInfoLite.builder().applyMutation(identityInfo)).build());
        }

        public Builder phoneConfig(UserPhoneConfig var1);

        default public Builder phoneConfig(Consumer<UserPhoneConfig.Builder> phoneConfig) {
            return this.phoneConfig((UserPhoneConfig)((UserPhoneConfig.Builder)UserPhoneConfig.builder().applyMutation(phoneConfig)).build());
        }

        public Builder routingProfileId(String var1);

        public Builder securityProfileIds(Collection<String> var1);

        public Builder securityProfileIds(String ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder username(String var1);
    }
}

