/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.HoursOfOperationOverride;
import software.amazon.awssdk.services.connect.model.SearchHoursOfOperationOverridesRequest;
import software.amazon.awssdk.services.connect.model.SearchHoursOfOperationOverridesResponse;

public class SearchHoursOfOperationOverridesIterable
implements SdkIterable<SearchHoursOfOperationOverridesResponse> {
    private final ConnectClient client;
    private final SearchHoursOfOperationOverridesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchHoursOfOperationOverridesIterable(ConnectClient client, SearchHoursOfOperationOverridesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchHoursOfOperationOverridesResponseFetcher();
    }

    public Iterator<SearchHoursOfOperationOverridesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<HoursOfOperationOverride> hoursOfOperationOverrides() {
        Function<SearchHoursOfOperationOverridesResponse, Iterator> getIterator = response -> {
            if (response != null && response.hoursOfOperationOverrides() != null) {
                return response.hoursOfOperationOverrides().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchHoursOfOperationOverridesResponseFetcher
    implements SyncPageFetcher<SearchHoursOfOperationOverridesResponse> {
        private SearchHoursOfOperationOverridesResponseFetcher() {
        }

        public boolean hasNextPage(SearchHoursOfOperationOverridesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchHoursOfOperationOverridesResponse nextPage(SearchHoursOfOperationOverridesResponse previousPage) {
            if (previousPage == null) {
                return SearchHoursOfOperationOverridesIterable.this.client.searchHoursOfOperationOverrides(SearchHoursOfOperationOverridesIterable.this.firstRequest);
            }
            return SearchHoursOfOperationOverridesIterable.this.client.searchHoursOfOperationOverrides((SearchHoursOfOperationOverridesRequest)((Object)SearchHoursOfOperationOverridesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

