/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.AttachedFile;
import software.amazon.awssdk.services.connect.model.AttachedFileError;
import software.amazon.awssdk.services.connect.model.AttachedFileErrorsListCopier;
import software.amazon.awssdk.services.connect.model.AttachedFilesListCopier;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetAttachedFileMetadataResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, BatchGetAttachedFileMetadataResponse> {
    private static final SdkField<List<AttachedFile>> FILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Files").getter(BatchGetAttachedFileMetadataResponse.getter(BatchGetAttachedFileMetadataResponse::files)).setter(BatchGetAttachedFileMetadataResponse.setter(Builder::files)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Files").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttachedFile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AttachedFileError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Errors").getter(BatchGetAttachedFileMetadataResponse.getter(BatchGetAttachedFileMetadataResponse::errors)).setter(BatchGetAttachedFileMetadataResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttachedFileError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILES_FIELD, ERRORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Files", FILES_FIELD);
            this.put("Errors", ERRORS_FIELD);
        }
    });
    private final List<AttachedFile> files;
    private final List<AttachedFileError> errors;

    private BatchGetAttachedFileMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.files = builder.files;
        this.errors = builder.errors;
    }

    public final boolean hasFiles() {
        return this.files != null && !(this.files instanceof SdkAutoConstructList);
    }

    public final List<AttachedFile> files() {
        return this.files;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<AttachedFileError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFiles() ? this.files() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetAttachedFileMetadataResponse)) {
            return false;
        }
        BatchGetAttachedFileMetadataResponse other = (BatchGetAttachedFileMetadataResponse)((Object)obj);
        return this.hasFiles() == other.hasFiles() && Objects.equals(this.files(), other.files()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetAttachedFileMetadataResponse").add("Files", this.hasFiles() ? this.files() : null).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Files": {
                return Optional.ofNullable(clazz.cast(this.files()));
            }
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetAttachedFileMetadataResponse, T> g) {
        return obj -> g.apply((BatchGetAttachedFileMetadataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<AttachedFile> files = DefaultSdkAutoConstructList.getInstance();
        private List<AttachedFileError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetAttachedFileMetadataResponse model) {
            super(model);
            this.files(model.files);
            this.errors(model.errors);
        }

        public final List<AttachedFile.Builder> getFiles() {
            List<AttachedFile.Builder> result = AttachedFilesListCopier.copyToBuilder(this.files);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFiles(Collection<AttachedFile.BuilderImpl> files) {
            this.files = AttachedFilesListCopier.copyFromBuilder(files);
        }

        @Override
        public final Builder files(Collection<AttachedFile> files) {
            this.files = AttachedFilesListCopier.copy(files);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder files(AttachedFile ... files) {
            this.files(Arrays.asList(files));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder files(Consumer<AttachedFile.Builder> ... files) {
            this.files(Stream.of(files).map(c -> (AttachedFile)((AttachedFile.Builder)AttachedFile.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AttachedFileError.Builder> getErrors() {
            List<AttachedFileError.Builder> result = AttachedFileErrorsListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<AttachedFileError.BuilderImpl> errors) {
            this.errors = AttachedFileErrorsListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<AttachedFileError> errors) {
            this.errors = AttachedFileErrorsListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(AttachedFileError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<AttachedFileError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (AttachedFileError)((AttachedFileError.Builder)AttachedFileError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetAttachedFileMetadataResponse build() {
            return new BatchGetAttachedFileMetadataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetAttachedFileMetadataResponse> {
        public Builder files(Collection<AttachedFile> var1);

        public Builder files(AttachedFile ... var1);

        public Builder files(Consumer<AttachedFile.Builder> ... var1);

        public Builder errors(Collection<AttachedFileError> var1);

        public Builder errors(AttachedFileError ... var1);

        public Builder errors(Consumer<AttachedFileError.Builder> ... var1);
    }
}

