/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.EvaluationScore;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluationMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluationMetadata> {
    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactId").getter(EvaluationMetadata.getter(EvaluationMetadata::contactId)).setter(EvaluationMetadata.setter(Builder::contactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactId").build()}).build();
    private static final SdkField<String> EVALUATOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluatorArn").getter(EvaluationMetadata.getter(EvaluationMetadata::evaluatorArn)).setter(EvaluationMetadata.setter(Builder::evaluatorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluatorArn").build()}).build();
    private static final SdkField<String> CONTACT_AGENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactAgentId").getter(EvaluationMetadata.getter(EvaluationMetadata::contactAgentId)).setter(EvaluationMetadata.setter(Builder::contactAgentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactAgentId").build()}).build();
    private static final SdkField<EvaluationScore> SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Score").getter(EvaluationMetadata.getter(EvaluationMetadata::score)).setter(EvaluationMetadata.setter(Builder::score)).constructor(EvaluationScore::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Score").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_ID_FIELD, EVALUATOR_ARN_FIELD, CONTACT_AGENT_ID_FIELD, SCORE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ContactId", CONTACT_ID_FIELD);
            this.put("EvaluatorArn", EVALUATOR_ARN_FIELD);
            this.put("ContactAgentId", CONTACT_AGENT_ID_FIELD);
            this.put("Score", SCORE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String contactId;
    private final String evaluatorArn;
    private final String contactAgentId;
    private final EvaluationScore score;

    private EvaluationMetadata(BuilderImpl builder) {
        this.contactId = builder.contactId;
        this.evaluatorArn = builder.evaluatorArn;
        this.contactAgentId = builder.contactAgentId;
        this.score = builder.score;
    }

    public final String contactId() {
        return this.contactId;
    }

    public final String evaluatorArn() {
        return this.evaluatorArn;
    }

    public final String contactAgentId() {
        return this.contactAgentId;
    }

    public final EvaluationScore score() {
        return this.score;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.contactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluatorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactAgentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.score());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationMetadata)) {
            return false;
        }
        EvaluationMetadata other = (EvaluationMetadata)obj;
        return Objects.equals(this.contactId(), other.contactId()) && Objects.equals(this.evaluatorArn(), other.evaluatorArn()) && Objects.equals(this.contactAgentId(), other.contactAgentId()) && Objects.equals(this.score(), other.score());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluationMetadata").add("ContactId", (Object)this.contactId()).add("EvaluatorArn", (Object)this.evaluatorArn()).add("ContactAgentId", (Object)this.contactAgentId()).add("Score", (Object)this.score()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContactId": {
                return Optional.ofNullable(clazz.cast(this.contactId()));
            }
            case "EvaluatorArn": {
                return Optional.ofNullable(clazz.cast(this.evaluatorArn()));
            }
            case "ContactAgentId": {
                return Optional.ofNullable(clazz.cast(this.contactAgentId()));
            }
            case "Score": {
                return Optional.ofNullable(clazz.cast(this.score()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EvaluationMetadata, T> g) {
        return obj -> g.apply((EvaluationMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String contactId;
        private String evaluatorArn;
        private String contactAgentId;
        private EvaluationScore score;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationMetadata model) {
            this.contactId(model.contactId);
            this.evaluatorArn(model.evaluatorArn);
            this.contactAgentId(model.contactAgentId);
            this.score(model.score);
        }

        public final String getContactId() {
            return this.contactId;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        @Override
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final String getEvaluatorArn() {
            return this.evaluatorArn;
        }

        public final void setEvaluatorArn(String evaluatorArn) {
            this.evaluatorArn = evaluatorArn;
        }

        @Override
        public final Builder evaluatorArn(String evaluatorArn) {
            this.evaluatorArn = evaluatorArn;
            return this;
        }

        public final String getContactAgentId() {
            return this.contactAgentId;
        }

        public final void setContactAgentId(String contactAgentId) {
            this.contactAgentId = contactAgentId;
        }

        @Override
        public final Builder contactAgentId(String contactAgentId) {
            this.contactAgentId = contactAgentId;
            return this;
        }

        public final EvaluationScore.Builder getScore() {
            return this.score != null ? this.score.toBuilder() : null;
        }

        public final void setScore(EvaluationScore.BuilderImpl score) {
            this.score = score != null ? score.build() : null;
        }

        @Override
        public final Builder score(EvaluationScore score) {
            this.score = score;
            return this;
        }

        public EvaluationMetadata build() {
            return new EvaluationMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluationMetadata> {
        public Builder contactId(String var1);

        public Builder evaluatorArn(String var1);

        public Builder contactAgentId(String var1);

        public Builder score(EvaluationScore var1);

        default public Builder score(Consumer<EvaluationScore.Builder> score) {
            return this.score((EvaluationScore)((EvaluationScore.Builder)EvaluationScore.builder().applyMutation(score)).build());
        }
    }
}

