/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.EmailAddressInfo;
import software.amazon.awssdk.services.connect.model.EmailAddressRecipientListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InboundAdditionalRecipients
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InboundAdditionalRecipients> {
    private static final SdkField<List<EmailAddressInfo>> TO_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ToAddresses").getter(InboundAdditionalRecipients.getter(InboundAdditionalRecipients::toAddresses)).setter(InboundAdditionalRecipients.setter(Builder::toAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToAddresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EmailAddressInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<EmailAddressInfo>> CC_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CcAddresses").getter(InboundAdditionalRecipients.getter(InboundAdditionalRecipients::ccAddresses)).setter(InboundAdditionalRecipients.setter(Builder::ccAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CcAddresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EmailAddressInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TO_ADDRESSES_FIELD, CC_ADDRESSES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ToAddresses", TO_ADDRESSES_FIELD);
            this.put("CcAddresses", CC_ADDRESSES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<EmailAddressInfo> toAddresses;
    private final List<EmailAddressInfo> ccAddresses;

    private InboundAdditionalRecipients(BuilderImpl builder) {
        this.toAddresses = builder.toAddresses;
        this.ccAddresses = builder.ccAddresses;
    }

    public final boolean hasToAddresses() {
        return this.toAddresses != null && !(this.toAddresses instanceof SdkAutoConstructList);
    }

    public final List<EmailAddressInfo> toAddresses() {
        return this.toAddresses;
    }

    public final boolean hasCcAddresses() {
        return this.ccAddresses != null && !(this.ccAddresses instanceof SdkAutoConstructList);
    }

    public final List<EmailAddressInfo> ccAddresses() {
        return this.ccAddresses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasToAddresses() ? this.toAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCcAddresses() ? this.ccAddresses() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InboundAdditionalRecipients)) {
            return false;
        }
        InboundAdditionalRecipients other = (InboundAdditionalRecipients)obj;
        return this.hasToAddresses() == other.hasToAddresses() && Objects.equals(this.toAddresses(), other.toAddresses()) && this.hasCcAddresses() == other.hasCcAddresses() && Objects.equals(this.ccAddresses(), other.ccAddresses());
    }

    public final String toString() {
        return ToString.builder((String)"InboundAdditionalRecipients").add("ToAddresses", this.hasToAddresses() ? this.toAddresses() : null).add("CcAddresses", this.hasCcAddresses() ? this.ccAddresses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ToAddresses": {
                return Optional.ofNullable(clazz.cast(this.toAddresses()));
            }
            case "CcAddresses": {
                return Optional.ofNullable(clazz.cast(this.ccAddresses()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InboundAdditionalRecipients, T> g) {
        return obj -> g.apply((InboundAdditionalRecipients)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<EmailAddressInfo> toAddresses = DefaultSdkAutoConstructList.getInstance();
        private List<EmailAddressInfo> ccAddresses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InboundAdditionalRecipients model) {
            this.toAddresses(model.toAddresses);
            this.ccAddresses(model.ccAddresses);
        }

        public final List<EmailAddressInfo.Builder> getToAddresses() {
            List<EmailAddressInfo.Builder> result = EmailAddressRecipientListCopier.copyToBuilder(this.toAddresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setToAddresses(Collection<EmailAddressInfo.BuilderImpl> toAddresses) {
            this.toAddresses = EmailAddressRecipientListCopier.copyFromBuilder(toAddresses);
        }

        @Override
        public final Builder toAddresses(Collection<EmailAddressInfo> toAddresses) {
            this.toAddresses = EmailAddressRecipientListCopier.copy(toAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder toAddresses(EmailAddressInfo ... toAddresses) {
            this.toAddresses(Arrays.asList(toAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder toAddresses(Consumer<EmailAddressInfo.Builder> ... toAddresses) {
            this.toAddresses(Stream.of(toAddresses).map(c -> (EmailAddressInfo)((EmailAddressInfo.Builder)EmailAddressInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<EmailAddressInfo.Builder> getCcAddresses() {
            List<EmailAddressInfo.Builder> result = EmailAddressRecipientListCopier.copyToBuilder(this.ccAddresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCcAddresses(Collection<EmailAddressInfo.BuilderImpl> ccAddresses) {
            this.ccAddresses = EmailAddressRecipientListCopier.copyFromBuilder(ccAddresses);
        }

        @Override
        public final Builder ccAddresses(Collection<EmailAddressInfo> ccAddresses) {
            this.ccAddresses = EmailAddressRecipientListCopier.copy(ccAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ccAddresses(EmailAddressInfo ... ccAddresses) {
            this.ccAddresses(Arrays.asList(ccAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ccAddresses(Consumer<EmailAddressInfo.Builder> ... ccAddresses) {
            this.ccAddresses(Stream.of(ccAddresses).map(c -> (EmailAddressInfo)((EmailAddressInfo.Builder)EmailAddressInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public InboundAdditionalRecipients build() {
            return new InboundAdditionalRecipients(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InboundAdditionalRecipients> {
        public Builder toAddresses(Collection<EmailAddressInfo> var1);

        public Builder toAddresses(EmailAddressInfo ... var1);

        public Builder toAddresses(Consumer<EmailAddressInfo.Builder> ... var1);

        public Builder ccAddresses(Collection<EmailAddressInfo> var1);

        public Builder ccAddresses(EmailAddressInfo ... var1);

        public Builder ccAddresses(Consumer<EmailAddressInfo.Builder> ... var1);
    }
}

