/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluationAnswerData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluationAnswerData> {
    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StringValue").getter(EvaluationAnswerData.getter(EvaluationAnswerData::stringValue)).setter(EvaluationAnswerData.setter(Builder::stringValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringValue").build()}).build();
    private static final SdkField<Double> NUMERIC_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("NumericValue").getter(EvaluationAnswerData.getter(EvaluationAnswerData::numericValue)).setter(EvaluationAnswerData.setter(Builder::numericValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumericValue").build()}).build();
    private static final SdkField<Boolean> NOT_APPLICABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("NotApplicable").getter(EvaluationAnswerData.getter(EvaluationAnswerData::notApplicable)).setter(EvaluationAnswerData.setter(Builder::notApplicable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotApplicable").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRING_VALUE_FIELD, NUMERIC_VALUE_FIELD, NOT_APPLICABLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("StringValue", STRING_VALUE_FIELD);
            this.put("NumericValue", NUMERIC_VALUE_FIELD);
            this.put("NotApplicable", NOT_APPLICABLE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String stringValue;
    private final Double numericValue;
    private final Boolean notApplicable;
    private final Type type;

    private EvaluationAnswerData(BuilderImpl builder) {
        this.stringValue = builder.stringValue;
        this.numericValue = builder.numericValue;
        this.notApplicable = builder.notApplicable;
        this.type = builder.type;
    }

    public final String stringValue() {
        return this.stringValue;
    }

    public final Double numericValue() {
        return this.numericValue;
    }

    public final Boolean notApplicable() {
        return this.notApplicable;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stringValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.numericValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.notApplicable());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationAnswerData)) {
            return false;
        }
        EvaluationAnswerData other = (EvaluationAnswerData)obj;
        return Objects.equals(this.stringValue(), other.stringValue()) && Objects.equals(this.numericValue(), other.numericValue()) && Objects.equals(this.notApplicable(), other.notApplicable());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluationAnswerData").add("StringValue", (Object)this.stringValue()).add("NumericValue", (Object)this.numericValue()).add("NotApplicable", (Object)this.notApplicable()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StringValue": {
                return Optional.ofNullable(clazz.cast(this.stringValue()));
            }
            case "NumericValue": {
                return Optional.ofNullable(clazz.cast(this.numericValue()));
            }
            case "NotApplicable": {
                return Optional.ofNullable(clazz.cast(this.notApplicable()));
            }
        }
        return Optional.empty();
    }

    public static EvaluationAnswerData fromStringValue(String stringValue) {
        return (EvaluationAnswerData)EvaluationAnswerData.builder().stringValue(stringValue).build();
    }

    public static EvaluationAnswerData fromNumericValue(Double numericValue) {
        return (EvaluationAnswerData)EvaluationAnswerData.builder().numericValue(numericValue).build();
    }

    public static EvaluationAnswerData fromNotApplicable(Boolean notApplicable) {
        return (EvaluationAnswerData)EvaluationAnswerData.builder().notApplicable(notApplicable).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EvaluationAnswerData, T> g) {
        return obj -> g.apply((EvaluationAnswerData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        STRING_VALUE,
        NUMERIC_VALUE,
        NOT_APPLICABLE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String stringValue;
        private Double numericValue;
        private Boolean notApplicable;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationAnswerData model) {
            this.stringValue(model.stringValue);
            this.numericValue(model.numericValue);
            this.notApplicable(model.notApplicable);
        }

        public final String getStringValue() {
            return this.stringValue;
        }

        public final void setStringValue(String stringValue) {
            String oldValue = this.stringValue;
            this.stringValue = stringValue;
            this.handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
        }

        @Override
        public final Builder stringValue(String stringValue) {
            String oldValue = this.stringValue;
            this.stringValue = stringValue;
            this.handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
            return this;
        }

        public final Double getNumericValue() {
            return this.numericValue;
        }

        public final void setNumericValue(Double numericValue) {
            Double oldValue = this.numericValue;
            this.numericValue = numericValue;
            this.handleUnionValueChange(Type.NUMERIC_VALUE, oldValue, this.numericValue);
        }

        @Override
        public final Builder numericValue(Double numericValue) {
            Double oldValue = this.numericValue;
            this.numericValue = numericValue;
            this.handleUnionValueChange(Type.NUMERIC_VALUE, oldValue, this.numericValue);
            return this;
        }

        public final Boolean getNotApplicable() {
            return this.notApplicable;
        }

        public final void setNotApplicable(Boolean notApplicable) {
            Boolean oldValue = this.notApplicable;
            this.notApplicable = notApplicable;
            this.handleUnionValueChange(Type.NOT_APPLICABLE, oldValue, this.notApplicable);
        }

        @Override
        public final Builder notApplicable(Boolean notApplicable) {
            Boolean oldValue = this.notApplicable;
            this.notApplicable = notApplicable;
            this.handleUnionValueChange(Type.NOT_APPLICABLE, oldValue, this.notApplicable);
            return this;
        }

        public EvaluationAnswerData build() {
            return new EvaluationAnswerData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluationAnswerData> {
        public Builder stringValue(String var1);

        public Builder numericValue(Double var1);

        public Builder notApplicable(Boolean var1);
    }
}

