/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.VideoCapability;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ParticipantCapabilities
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ParticipantCapabilities> {
    private static final SdkField<String> VIDEO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Video").getter(ParticipantCapabilities.getter(ParticipantCapabilities::videoAsString)).setter(ParticipantCapabilities.setter(Builder::video)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Video").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIDEO_FIELD));
    private static final long serialVersionUID = 1L;
    private final String video;

    private ParticipantCapabilities(BuilderImpl builder) {
        this.video = builder.video;
    }

    public final VideoCapability video() {
        return VideoCapability.fromValue(this.video);
    }

    public final String videoAsString() {
        return this.video;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.videoAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParticipantCapabilities)) {
            return false;
        }
        ParticipantCapabilities other = (ParticipantCapabilities)obj;
        return Objects.equals(this.videoAsString(), other.videoAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ParticipantCapabilities").add("Video", (Object)this.videoAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Video": {
                return Optional.ofNullable(clazz.cast(this.videoAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParticipantCapabilities, T> g) {
        return obj -> g.apply((ParticipantCapabilities)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String video;

        private BuilderImpl() {
        }

        private BuilderImpl(ParticipantCapabilities model) {
            this.video(model.video);
        }

        public final String getVideo() {
            return this.video;
        }

        public final void setVideo(String video) {
            this.video = video;
        }

        @Override
        public final Builder video(String video) {
            this.video = video;
            return this;
        }

        @Override
        public final Builder video(VideoCapability video) {
            this.video(video == null ? null : video.toString());
            return this;
        }

        public ParticipantCapabilities build() {
            return new ParticipantCapabilities(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ParticipantCapabilities> {
        public Builder video(String var1);

        public Builder video(VideoCapability var1);
    }
}

