/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.CreatedByInfo;
import software.amazon.awssdk.services.connect.model.DownloadUrlMetadata;
import software.amazon.awssdk.services.connect.model.FileStatusType;
import software.amazon.awssdk.services.connect.model.FileUseCaseType;
import software.amazon.awssdk.services.connect.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAttachedFileResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, GetAttachedFileResponse> {
    private static final SdkField<String> FILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileArn").getter(GetAttachedFileResponse.getter(GetAttachedFileResponse::fileArn)).setter(GetAttachedFileResponse.setter(Builder::fileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileArn").build()}).build();
    private static final SdkField<String> FILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileId").getter(GetAttachedFileResponse.getter(GetAttachedFileResponse::fileId)).setter(GetAttachedFileResponse.setter(Builder::fileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileId").build()}).build();
    private static final SdkField<String> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreationTime").getter(GetAttachedFileResponse.getter(GetAttachedFileResponse::creationTime)).setter(GetAttachedFileResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> FILE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileStatus").getter(GetAttachedFileResponse.getter(GetAttachedFileResponse::fileStatusAsString)).setter(GetAttachedFileResponse.setter(Builder::fileStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileStatus").build()}).build();
    private static final SdkField<String> FILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileName").getter(GetAttachedFileResponse.getter(GetAttachedFileResponse::fileName)).setter(GetAttachedFileResponse.setter(Builder::fileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileName").build()}).build();
    private static final SdkField<Long> FILE_SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("FileSizeInBytes").getter(GetAttachedFileResponse.getter(GetAttachedFileResponse::fileSizeInBytes)).setter(GetAttachedFileResponse.setter(Builder::fileSizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSizeInBytes").build()}).build();
    private static final SdkField<String> ASSOCIATED_RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociatedResourceArn").getter(GetAttachedFileResponse.getter(GetAttachedFileResponse::associatedResourceArn)).setter(GetAttachedFileResponse.setter(Builder::associatedResourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedResourceArn").build()}).build();
    private static final SdkField<String> FILE_USE_CASE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileUseCaseType").getter(GetAttachedFileResponse.getter(GetAttachedFileResponse::fileUseCaseTypeAsString)).setter(GetAttachedFileResponse.setter(Builder::fileUseCaseType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileUseCaseType").build()}).build();
    private static final SdkField<CreatedByInfo> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CreatedBy").getter(GetAttachedFileResponse.getter(GetAttachedFileResponse::createdBy)).setter(GetAttachedFileResponse.setter(Builder::createdBy)).constructor(CreatedByInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<DownloadUrlMetadata> DOWNLOAD_URL_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DownloadUrlMetadata").getter(GetAttachedFileResponse.getter(GetAttachedFileResponse::downloadUrlMetadata)).setter(GetAttachedFileResponse.setter(Builder::downloadUrlMetadata)).constructor(DownloadUrlMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DownloadUrlMetadata").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(GetAttachedFileResponse.getter(GetAttachedFileResponse::tags)).setter(GetAttachedFileResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_ARN_FIELD, FILE_ID_FIELD, CREATION_TIME_FIELD, FILE_STATUS_FIELD, FILE_NAME_FIELD, FILE_SIZE_IN_BYTES_FIELD, ASSOCIATED_RESOURCE_ARN_FIELD, FILE_USE_CASE_TYPE_FIELD, CREATED_BY_FIELD, DOWNLOAD_URL_METADATA_FIELD, TAGS_FIELD));
    private final String fileArn;
    private final String fileId;
    private final String creationTime;
    private final String fileStatus;
    private final String fileName;
    private final Long fileSizeInBytes;
    private final String associatedResourceArn;
    private final String fileUseCaseType;
    private final CreatedByInfo createdBy;
    private final DownloadUrlMetadata downloadUrlMetadata;
    private final Map<String, String> tags;

    private GetAttachedFileResponse(BuilderImpl builder) {
        super(builder);
        this.fileArn = builder.fileArn;
        this.fileId = builder.fileId;
        this.creationTime = builder.creationTime;
        this.fileStatus = builder.fileStatus;
        this.fileName = builder.fileName;
        this.fileSizeInBytes = builder.fileSizeInBytes;
        this.associatedResourceArn = builder.associatedResourceArn;
        this.fileUseCaseType = builder.fileUseCaseType;
        this.createdBy = builder.createdBy;
        this.downloadUrlMetadata = builder.downloadUrlMetadata;
        this.tags = builder.tags;
    }

    public final String fileArn() {
        return this.fileArn;
    }

    public final String fileId() {
        return this.fileId;
    }

    public final String creationTime() {
        return this.creationTime;
    }

    public final FileStatusType fileStatus() {
        return FileStatusType.fromValue(this.fileStatus);
    }

    public final String fileStatusAsString() {
        return this.fileStatus;
    }

    public final String fileName() {
        return this.fileName;
    }

    public final Long fileSizeInBytes() {
        return this.fileSizeInBytes;
    }

    public final String associatedResourceArn() {
        return this.associatedResourceArn;
    }

    public final FileUseCaseType fileUseCaseType() {
        return FileUseCaseType.fromValue(this.fileUseCaseType);
    }

    public final String fileUseCaseTypeAsString() {
        return this.fileUseCaseType;
    }

    public final CreatedByInfo createdBy() {
        return this.createdBy;
    }

    public final DownloadUrlMetadata downloadUrlMetadata() {
        return this.downloadUrlMetadata;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileUseCaseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.downloadUrlMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAttachedFileResponse)) {
            return false;
        }
        GetAttachedFileResponse other = (GetAttachedFileResponse)((Object)obj);
        return Objects.equals(this.fileArn(), other.fileArn()) && Objects.equals(this.fileId(), other.fileId()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.fileStatusAsString(), other.fileStatusAsString()) && Objects.equals(this.fileName(), other.fileName()) && Objects.equals(this.fileSizeInBytes(), other.fileSizeInBytes()) && Objects.equals(this.associatedResourceArn(), other.associatedResourceArn()) && Objects.equals(this.fileUseCaseTypeAsString(), other.fileUseCaseTypeAsString()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.downloadUrlMetadata(), other.downloadUrlMetadata()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetAttachedFileResponse").add("FileArn", (Object)this.fileArn()).add("FileId", (Object)this.fileId()).add("CreationTime", (Object)this.creationTime()).add("FileStatus", (Object)this.fileStatusAsString()).add("FileName", (Object)this.fileName()).add("FileSizeInBytes", (Object)this.fileSizeInBytes()).add("AssociatedResourceArn", (Object)this.associatedResourceArn()).add("FileUseCaseType", (Object)this.fileUseCaseTypeAsString()).add("CreatedBy", (Object)this.createdBy()).add("DownloadUrlMetadata", (Object)this.downloadUrlMetadata()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FileArn": {
                return Optional.ofNullable(clazz.cast(this.fileArn()));
            }
            case "FileId": {
                return Optional.ofNullable(clazz.cast(this.fileId()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "FileStatus": {
                return Optional.ofNullable(clazz.cast(this.fileStatusAsString()));
            }
            case "FileName": {
                return Optional.ofNullable(clazz.cast(this.fileName()));
            }
            case "FileSizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.fileSizeInBytes()));
            }
            case "AssociatedResourceArn": {
                return Optional.ofNullable(clazz.cast(this.associatedResourceArn()));
            }
            case "FileUseCaseType": {
                return Optional.ofNullable(clazz.cast(this.fileUseCaseTypeAsString()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "DownloadUrlMetadata": {
                return Optional.ofNullable(clazz.cast(this.downloadUrlMetadata()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAttachedFileResponse, T> g) {
        return obj -> g.apply((GetAttachedFileResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private String fileArn;
        private String fileId;
        private String creationTime;
        private String fileStatus;
        private String fileName;
        private Long fileSizeInBytes;
        private String associatedResourceArn;
        private String fileUseCaseType;
        private CreatedByInfo createdBy;
        private DownloadUrlMetadata downloadUrlMetadata;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetAttachedFileResponse model) {
            super(model);
            this.fileArn(model.fileArn);
            this.fileId(model.fileId);
            this.creationTime(model.creationTime);
            this.fileStatus(model.fileStatus);
            this.fileName(model.fileName);
            this.fileSizeInBytes(model.fileSizeInBytes);
            this.associatedResourceArn(model.associatedResourceArn);
            this.fileUseCaseType(model.fileUseCaseType);
            this.createdBy(model.createdBy);
            this.downloadUrlMetadata(model.downloadUrlMetadata);
            this.tags(model.tags);
        }

        public final String getFileArn() {
            return this.fileArn;
        }

        public final void setFileArn(String fileArn) {
            this.fileArn = fileArn;
        }

        @Override
        public final Builder fileArn(String fileArn) {
            this.fileArn = fileArn;
            return this;
        }

        public final String getFileId() {
            return this.fileId;
        }

        public final void setFileId(String fileId) {
            this.fileId = fileId;
        }

        @Override
        public final Builder fileId(String fileId) {
            this.fileId = fileId;
            return this;
        }

        public final String getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getFileStatus() {
            return this.fileStatus;
        }

        public final void setFileStatus(String fileStatus) {
            this.fileStatus = fileStatus;
        }

        @Override
        public final Builder fileStatus(String fileStatus) {
            this.fileStatus = fileStatus;
            return this;
        }

        @Override
        public final Builder fileStatus(FileStatusType fileStatus) {
            this.fileStatus(fileStatus == null ? null : fileStatus.toString());
            return this;
        }

        public final String getFileName() {
            return this.fileName;
        }

        public final void setFileName(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public final Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public final Long getFileSizeInBytes() {
            return this.fileSizeInBytes;
        }

        public final void setFileSizeInBytes(Long fileSizeInBytes) {
            this.fileSizeInBytes = fileSizeInBytes;
        }

        @Override
        public final Builder fileSizeInBytes(Long fileSizeInBytes) {
            this.fileSizeInBytes = fileSizeInBytes;
            return this;
        }

        public final String getAssociatedResourceArn() {
            return this.associatedResourceArn;
        }

        public final void setAssociatedResourceArn(String associatedResourceArn) {
            this.associatedResourceArn = associatedResourceArn;
        }

        @Override
        public final Builder associatedResourceArn(String associatedResourceArn) {
            this.associatedResourceArn = associatedResourceArn;
            return this;
        }

        public final String getFileUseCaseType() {
            return this.fileUseCaseType;
        }

        public final void setFileUseCaseType(String fileUseCaseType) {
            this.fileUseCaseType = fileUseCaseType;
        }

        @Override
        public final Builder fileUseCaseType(String fileUseCaseType) {
            this.fileUseCaseType = fileUseCaseType;
            return this;
        }

        @Override
        public final Builder fileUseCaseType(FileUseCaseType fileUseCaseType) {
            this.fileUseCaseType(fileUseCaseType == null ? null : fileUseCaseType.toString());
            return this;
        }

        public final CreatedByInfo.Builder getCreatedBy() {
            return this.createdBy != null ? this.createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(CreatedByInfo.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        public final Builder createdBy(CreatedByInfo createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final DownloadUrlMetadata.Builder getDownloadUrlMetadata() {
            return this.downloadUrlMetadata != null ? this.downloadUrlMetadata.toBuilder() : null;
        }

        public final void setDownloadUrlMetadata(DownloadUrlMetadata.BuilderImpl downloadUrlMetadata) {
            this.downloadUrlMetadata = downloadUrlMetadata != null ? downloadUrlMetadata.build() : null;
        }

        @Override
        public final Builder downloadUrlMetadata(DownloadUrlMetadata downloadUrlMetadata) {
            this.downloadUrlMetadata = downloadUrlMetadata;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetAttachedFileResponse build() {
            return new GetAttachedFileResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAttachedFileResponse> {
        public Builder fileArn(String var1);

        public Builder fileId(String var1);

        public Builder creationTime(String var1);

        public Builder fileStatus(String var1);

        public Builder fileStatus(FileStatusType var1);

        public Builder fileName(String var1);

        public Builder fileSizeInBytes(Long var1);

        public Builder associatedResourceArn(String var1);

        public Builder fileUseCaseType(String var1);

        public Builder fileUseCaseType(FileUseCaseType var1);

        public Builder createdBy(CreatedByInfo var1);

        default public Builder createdBy(Consumer<CreatedByInfo.Builder> createdBy) {
            return this.createdBy((CreatedByInfo)((CreatedByInfo.Builder)CreatedByInfo.builder().applyMutation(createdBy)).build());
        }

        public Builder downloadUrlMetadata(DownloadUrlMetadata var1);

        default public Builder downloadUrlMetadata(Consumer<DownloadUrlMetadata.Builder> downloadUrlMetadata) {
            return this.downloadUrlMetadata((DownloadUrlMetadata)((DownloadUrlMetadata.Builder)DownloadUrlMetadata.builder().applyMutation(downloadUrlMetadata)).build());
        }

        public Builder tags(Map<String, String> var1);
    }
}

