/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.ContactFlow;
import software.amazon.awssdk.services.connect.model.SearchContactFlowsRequest;
import software.amazon.awssdk.services.connect.model.SearchContactFlowsResponse;

public class SearchContactFlowsPublisher
implements SdkPublisher<SearchContactFlowsResponse> {
    private final ConnectAsyncClient client;
    private final SearchContactFlowsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchContactFlowsPublisher(ConnectAsyncClient client, SearchContactFlowsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchContactFlowsPublisher(ConnectAsyncClient client, SearchContactFlowsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchContactFlowsResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchContactFlowsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ContactFlow> contactFlows() {
        Function<SearchContactFlowsResponse, Iterator> getIterator = response -> {
            if (response != null && response.contactFlows() != null) {
                return response.contactFlows().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchContactFlowsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchContactFlowsResponseFetcher
    implements AsyncPageFetcher<SearchContactFlowsResponse> {
        private SearchContactFlowsResponseFetcher() {
        }

        public boolean hasNextPage(SearchContactFlowsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchContactFlowsResponse> nextPage(SearchContactFlowsResponse previousPage) {
            if (previousPage == null) {
                return SearchContactFlowsPublisher.this.client.searchContactFlows(SearchContactFlowsPublisher.this.firstRequest);
            }
            return SearchContactFlowsPublisher.this.client.searchContactFlows((SearchContactFlowsRequest)((Object)SearchContactFlowsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

