/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.ListSecurityProfilesRequest;
import software.amazon.awssdk.services.connect.model.ListSecurityProfilesResponse;
import software.amazon.awssdk.services.connect.model.SecurityProfileSummary;

public class ListSecurityProfilesPublisher
implements SdkPublisher<ListSecurityProfilesResponse> {
    private final ConnectAsyncClient client;
    private final ListSecurityProfilesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSecurityProfilesPublisher(ConnectAsyncClient client, ListSecurityProfilesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSecurityProfilesPublisher(ConnectAsyncClient client, ListSecurityProfilesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSecurityProfilesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSecurityProfilesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SecurityProfileSummary> securityProfileSummaryList() {
        Function<ListSecurityProfilesResponse, Iterator> getIterator = response -> {
            if (response != null && response.securityProfileSummaryList() != null) {
                return response.securityProfileSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSecurityProfilesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSecurityProfilesResponseFetcher
    implements AsyncPageFetcher<ListSecurityProfilesResponse> {
        private ListSecurityProfilesResponseFetcher() {
        }

        public boolean hasNextPage(ListSecurityProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSecurityProfilesResponse> nextPage(ListSecurityProfilesResponse previousPage) {
            if (previousPage == null) {
                return ListSecurityProfilesPublisher.this.client.listSecurityProfiles(ListSecurityProfilesPublisher.this.firstRequest);
            }
            return ListSecurityProfilesPublisher.this.client.listSecurityProfiles((ListSecurityProfilesRequest)((Object)ListSecurityProfilesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

