/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.UserProficiencyDisassociate;
import software.amazon.awssdk.services.connect.model.UserProficiencyDisassociateListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisassociateUserProficienciesRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, DisassociateUserProficienciesRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(DisassociateUserProficienciesRequest.getter(DisassociateUserProficienciesRequest::instanceId)).setter(DisassociateUserProficienciesRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserId").getter(DisassociateUserProficienciesRequest.getter(DisassociateUserProficienciesRequest::userId)).setter(DisassociateUserProficienciesRequest.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("UserId").build()}).build();
    private static final SdkField<List<UserProficiencyDisassociate>> USER_PROFICIENCIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserProficiencies").getter(DisassociateUserProficienciesRequest.getter(DisassociateUserProficienciesRequest::userProficiencies)).setter(DisassociateUserProficienciesRequest.setter(Builder::userProficiencies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserProficiencies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UserProficiencyDisassociate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, USER_ID_FIELD, USER_PROFICIENCIES_FIELD));
    private final String instanceId;
    private final String userId;
    private final List<UserProficiencyDisassociate> userProficiencies;

    private DisassociateUserProficienciesRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.userId = builder.userId;
        this.userProficiencies = builder.userProficiencies;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String userId() {
        return this.userId;
    }

    public final boolean hasUserProficiencies() {
        return this.userProficiencies != null && !(this.userProficiencies instanceof SdkAutoConstructList);
    }

    public final List<UserProficiencyDisassociate> userProficiencies() {
        return this.userProficiencies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserProficiencies() ? this.userProficiencies() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateUserProficienciesRequest)) {
            return false;
        }
        DisassociateUserProficienciesRequest other = (DisassociateUserProficienciesRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.userId(), other.userId()) && this.hasUserProficiencies() == other.hasUserProficiencies() && Objects.equals(this.userProficiencies(), other.userProficiencies());
    }

    public final String toString() {
        return ToString.builder((String)"DisassociateUserProficienciesRequest").add("InstanceId", (Object)this.instanceId()).add("UserId", (Object)this.userId()).add("UserProficiencies", this.hasUserProficiencies() ? this.userProficiencies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "UserProficiencies": {
                return Optional.ofNullable(clazz.cast(this.userProficiencies()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateUserProficienciesRequest, T> g) {
        return obj -> g.apply((DisassociateUserProficienciesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String userId;
        private List<UserProficiencyDisassociate> userProficiencies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateUserProficienciesRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.userId(model.userId);
            this.userProficiencies(model.userProficiencies);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final List<UserProficiencyDisassociate.Builder> getUserProficiencies() {
            List<UserProficiencyDisassociate.Builder> result = UserProficiencyDisassociateListCopier.copyToBuilder(this.userProficiencies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserProficiencies(Collection<UserProficiencyDisassociate.BuilderImpl> userProficiencies) {
            this.userProficiencies = UserProficiencyDisassociateListCopier.copyFromBuilder(userProficiencies);
        }

        @Override
        public final Builder userProficiencies(Collection<UserProficiencyDisassociate> userProficiencies) {
            this.userProficiencies = UserProficiencyDisassociateListCopier.copy(userProficiencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userProficiencies(UserProficiencyDisassociate ... userProficiencies) {
            this.userProficiencies(Arrays.asList(userProficiencies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userProficiencies(Consumer<UserProficiencyDisassociate.Builder> ... userProficiencies) {
            this.userProficiencies(Stream.of(userProficiencies).map(c -> (UserProficiencyDisassociate)((UserProficiencyDisassociate.Builder)UserProficiencyDisassociate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateUserProficienciesRequest build() {
            return new DisassociateUserProficienciesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisassociateUserProficienciesRequest> {
        public Builder instanceId(String var1);

        public Builder userId(String var1);

        public Builder userProficiencies(Collection<UserProficiencyDisassociate> var1);

        public Builder userProficiencies(UserProficiencyDisassociate ... var1);

        public Builder userProficiencies(Consumer<UserProficiencyDisassociate.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

