/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.ListQuickConnectsRequest;
import software.amazon.awssdk.services.connect.model.ListQuickConnectsResponse;
import software.amazon.awssdk.services.connect.model.QuickConnectSummary;

public class ListQuickConnectsIterable
implements SdkIterable<ListQuickConnectsResponse> {
    private final ConnectClient client;
    private final ListQuickConnectsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListQuickConnectsIterable(ConnectClient client, ListQuickConnectsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListQuickConnectsResponseFetcher();
    }

    public Iterator<ListQuickConnectsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<QuickConnectSummary> quickConnectSummaryList() {
        Function<ListQuickConnectsResponse, Iterator> getIterator = response -> {
            if (response != null && response.quickConnectSummaryList() != null) {
                return response.quickConnectSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListQuickConnectsResponseFetcher
    implements SyncPageFetcher<ListQuickConnectsResponse> {
        private ListQuickConnectsResponseFetcher() {
        }

        public boolean hasNextPage(ListQuickConnectsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListQuickConnectsResponse nextPage(ListQuickConnectsResponse previousPage) {
            if (previousPage == null) {
                return ListQuickConnectsIterable.this.client.listQuickConnects(ListQuickConnectsIterable.this.firstRequest);
            }
            return ListQuickConnectsIterable.this.client.listQuickConnects((ListQuickConnectsRequest)((Object)ListQuickConnectsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

