/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.ListTrafficDistributionGroupUsersRequest;
import software.amazon.awssdk.services.connect.model.ListTrafficDistributionGroupUsersResponse;
import software.amazon.awssdk.services.connect.model.TrafficDistributionGroupUserSummary;

public class ListTrafficDistributionGroupUsersPublisher
implements SdkPublisher<ListTrafficDistributionGroupUsersResponse> {
    private final ConnectAsyncClient client;
    private final ListTrafficDistributionGroupUsersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTrafficDistributionGroupUsersPublisher(ConnectAsyncClient client, ListTrafficDistributionGroupUsersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTrafficDistributionGroupUsersPublisher(ConnectAsyncClient client, ListTrafficDistributionGroupUsersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTrafficDistributionGroupUsersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTrafficDistributionGroupUsersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TrafficDistributionGroupUserSummary> trafficDistributionGroupUserSummaryList() {
        Function<ListTrafficDistributionGroupUsersResponse, Iterator> getIterator = response -> {
            if (response != null && response.trafficDistributionGroupUserSummaryList() != null) {
                return response.trafficDistributionGroupUserSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTrafficDistributionGroupUsersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTrafficDistributionGroupUsersResponseFetcher
    implements AsyncPageFetcher<ListTrafficDistributionGroupUsersResponse> {
        private ListTrafficDistributionGroupUsersResponseFetcher() {
        }

        public boolean hasNextPage(ListTrafficDistributionGroupUsersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTrafficDistributionGroupUsersResponse> nextPage(ListTrafficDistributionGroupUsersResponse previousPage) {
            if (previousPage == null) {
                return ListTrafficDistributionGroupUsersPublisher.this.client.listTrafficDistributionGroupUsers(ListTrafficDistributionGroupUsersPublisher.this.firstRequest);
            }
            return ListTrafficDistributionGroupUsersPublisher.this.client.listTrafficDistributionGroupUsers((ListTrafficDistributionGroupUsersRequest)((Object)ListTrafficDistributionGroupUsersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

