/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NotificationContentType {
    PLAIN_TEXT("PLAIN_TEXT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NotificationContentType> VALUE_MAP;
    private final String value;

    private NotificationContentType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NotificationContentType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NotificationContentType> knownValues() {
        EnumSet<NotificationContentType> knownValues = EnumSet.allOf(NotificationContentType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NotificationContentType.class, NotificationContentType::toString);
    }
}

