/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.model.HoursOfOperation;
import software.amazon.awssdk.services.connect.model.SearchHoursOfOperationsRequest;
import software.amazon.awssdk.services.connect.model.SearchHoursOfOperationsResponse;

public class SearchHoursOfOperationsIterable
implements SdkIterable<SearchHoursOfOperationsResponse> {
    private final ConnectClient client;
    private final SearchHoursOfOperationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchHoursOfOperationsIterable(ConnectClient client, SearchHoursOfOperationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new SearchHoursOfOperationsResponseFetcher();
    }

    public Iterator<SearchHoursOfOperationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<HoursOfOperation> hoursOfOperations() {
        Function<SearchHoursOfOperationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.hoursOfOperations() != null) {
                return response.hoursOfOperations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchHoursOfOperationsResponseFetcher
    implements SyncPageFetcher<SearchHoursOfOperationsResponse> {
        private SearchHoursOfOperationsResponseFetcher() {
        }

        public boolean hasNextPage(SearchHoursOfOperationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchHoursOfOperationsResponse nextPage(SearchHoursOfOperationsResponse previousPage) {
            if (previousPage == null) {
                return SearchHoursOfOperationsIterable.this.client.searchHoursOfOperations(SearchHoursOfOperationsIterable.this.firstRequest);
            }
            return SearchHoursOfOperationsIterable.this.client.searchHoursOfOperations((SearchHoursOfOperationsRequest)((Object)SearchHoursOfOperationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

