/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ActionType;
import software.amazon.awssdk.services.connect.model.AssignContactCategoryActionDefinition;
import software.amazon.awssdk.services.connect.model.EventBridgeActionDefinition;
import software.amazon.awssdk.services.connect.model.SendNotificationActionDefinition;
import software.amazon.awssdk.services.connect.model.TaskActionDefinition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuleAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuleAction> {
    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActionType").getter(RuleAction.getter(RuleAction::actionTypeAsString)).setter(RuleAction.setter(Builder::actionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionType").build()}).build();
    private static final SdkField<TaskActionDefinition> TASK_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TaskAction").getter(RuleAction.getter(RuleAction::taskAction)).setter(RuleAction.setter(Builder::taskAction)).constructor(TaskActionDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskAction").build()}).build();
    private static final SdkField<EventBridgeActionDefinition> EVENT_BRIDGE_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EventBridgeAction").getter(RuleAction.getter(RuleAction::eventBridgeAction)).setter(RuleAction.setter(Builder::eventBridgeAction)).constructor(EventBridgeActionDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventBridgeAction").build()}).build();
    private static final SdkField<AssignContactCategoryActionDefinition> ASSIGN_CONTACT_CATEGORY_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AssignContactCategoryAction").getter(RuleAction.getter(RuleAction::assignContactCategoryAction)).setter(RuleAction.setter(Builder::assignContactCategoryAction)).constructor(AssignContactCategoryActionDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignContactCategoryAction").build()}).build();
    private static final SdkField<SendNotificationActionDefinition> SEND_NOTIFICATION_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SendNotificationAction").getter(RuleAction.getter(RuleAction::sendNotificationAction)).setter(RuleAction.setter(Builder::sendNotificationAction)).constructor(SendNotificationActionDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SendNotificationAction").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_TYPE_FIELD, TASK_ACTION_FIELD, EVENT_BRIDGE_ACTION_FIELD, ASSIGN_CONTACT_CATEGORY_ACTION_FIELD, SEND_NOTIFICATION_ACTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String actionType;
    private final TaskActionDefinition taskAction;
    private final EventBridgeActionDefinition eventBridgeAction;
    private final AssignContactCategoryActionDefinition assignContactCategoryAction;
    private final SendNotificationActionDefinition sendNotificationAction;

    private RuleAction(BuilderImpl builder) {
        this.actionType = builder.actionType;
        this.taskAction = builder.taskAction;
        this.eventBridgeAction = builder.eventBridgeAction;
        this.assignContactCategoryAction = builder.assignContactCategoryAction;
        this.sendNotificationAction = builder.sendNotificationAction;
    }

    public final ActionType actionType() {
        return ActionType.fromValue(this.actionType);
    }

    public final String actionTypeAsString() {
        return this.actionType;
    }

    public final TaskActionDefinition taskAction() {
        return this.taskAction;
    }

    public final EventBridgeActionDefinition eventBridgeAction() {
        return this.eventBridgeAction;
    }

    public final AssignContactCategoryActionDefinition assignContactCategoryAction() {
        return this.assignContactCategoryAction;
    }

    public final SendNotificationActionDefinition sendNotificationAction() {
        return this.sendNotificationAction;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventBridgeAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.assignContactCategoryAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.sendNotificationAction());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleAction)) {
            return false;
        }
        RuleAction other = (RuleAction)obj;
        return Objects.equals(this.actionTypeAsString(), other.actionTypeAsString()) && Objects.equals(this.taskAction(), other.taskAction()) && Objects.equals(this.eventBridgeAction(), other.eventBridgeAction()) && Objects.equals(this.assignContactCategoryAction(), other.assignContactCategoryAction()) && Objects.equals(this.sendNotificationAction(), other.sendNotificationAction());
    }

    public final String toString() {
        return ToString.builder((String)"RuleAction").add("ActionType", (Object)this.actionTypeAsString()).add("TaskAction", (Object)this.taskAction()).add("EventBridgeAction", (Object)this.eventBridgeAction()).add("AssignContactCategoryAction", (Object)this.assignContactCategoryAction()).add("SendNotificationAction", (Object)this.sendNotificationAction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActionType": {
                return Optional.ofNullable(clazz.cast(this.actionTypeAsString()));
            }
            case "TaskAction": {
                return Optional.ofNullable(clazz.cast(this.taskAction()));
            }
            case "EventBridgeAction": {
                return Optional.ofNullable(clazz.cast(this.eventBridgeAction()));
            }
            case "AssignContactCategoryAction": {
                return Optional.ofNullable(clazz.cast(this.assignContactCategoryAction()));
            }
            case "SendNotificationAction": {
                return Optional.ofNullable(clazz.cast(this.sendNotificationAction()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuleAction, T> g) {
        return obj -> g.apply((RuleAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String actionType;
        private TaskActionDefinition taskAction;
        private EventBridgeActionDefinition eventBridgeAction;
        private AssignContactCategoryActionDefinition assignContactCategoryAction;
        private SendNotificationActionDefinition sendNotificationAction;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleAction model) {
            this.actionType(model.actionType);
            this.taskAction(model.taskAction);
            this.eventBridgeAction(model.eventBridgeAction);
            this.assignContactCategoryAction(model.assignContactCategoryAction);
            this.sendNotificationAction(model.sendNotificationAction);
        }

        public final String getActionType() {
            return this.actionType;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public final Builder actionType(ActionType actionType) {
            this.actionType(actionType == null ? null : actionType.toString());
            return this;
        }

        public final TaskActionDefinition.Builder getTaskAction() {
            return this.taskAction != null ? this.taskAction.toBuilder() : null;
        }

        public final void setTaskAction(TaskActionDefinition.BuilderImpl taskAction) {
            this.taskAction = taskAction != null ? taskAction.build() : null;
        }

        @Override
        public final Builder taskAction(TaskActionDefinition taskAction) {
            this.taskAction = taskAction;
            return this;
        }

        public final EventBridgeActionDefinition.Builder getEventBridgeAction() {
            return this.eventBridgeAction != null ? this.eventBridgeAction.toBuilder() : null;
        }

        public final void setEventBridgeAction(EventBridgeActionDefinition.BuilderImpl eventBridgeAction) {
            this.eventBridgeAction = eventBridgeAction != null ? eventBridgeAction.build() : null;
        }

        @Override
        public final Builder eventBridgeAction(EventBridgeActionDefinition eventBridgeAction) {
            this.eventBridgeAction = eventBridgeAction;
            return this;
        }

        public final AssignContactCategoryActionDefinition.Builder getAssignContactCategoryAction() {
            return this.assignContactCategoryAction != null ? this.assignContactCategoryAction.toBuilder() : null;
        }

        public final void setAssignContactCategoryAction(AssignContactCategoryActionDefinition.BuilderImpl assignContactCategoryAction) {
            this.assignContactCategoryAction = assignContactCategoryAction != null ? assignContactCategoryAction.build() : null;
        }

        @Override
        public final Builder assignContactCategoryAction(AssignContactCategoryActionDefinition assignContactCategoryAction) {
            this.assignContactCategoryAction = assignContactCategoryAction;
            return this;
        }

        public final SendNotificationActionDefinition.Builder getSendNotificationAction() {
            return this.sendNotificationAction != null ? this.sendNotificationAction.toBuilder() : null;
        }

        public final void setSendNotificationAction(SendNotificationActionDefinition.BuilderImpl sendNotificationAction) {
            this.sendNotificationAction = sendNotificationAction != null ? sendNotificationAction.build() : null;
        }

        @Override
        public final Builder sendNotificationAction(SendNotificationActionDefinition sendNotificationAction) {
            this.sendNotificationAction = sendNotificationAction;
            return this;
        }

        public RuleAction build() {
            return new RuleAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuleAction> {
        public Builder actionType(String var1);

        public Builder actionType(ActionType var1);

        public Builder taskAction(TaskActionDefinition var1);

        default public Builder taskAction(Consumer<TaskActionDefinition.Builder> taskAction) {
            return this.taskAction((TaskActionDefinition)((TaskActionDefinition.Builder)TaskActionDefinition.builder().applyMutation(taskAction)).build());
        }

        public Builder eventBridgeAction(EventBridgeActionDefinition var1);

        default public Builder eventBridgeAction(Consumer<EventBridgeActionDefinition.Builder> eventBridgeAction) {
            return this.eventBridgeAction((EventBridgeActionDefinition)((EventBridgeActionDefinition.Builder)EventBridgeActionDefinition.builder().applyMutation(eventBridgeAction)).build());
        }

        public Builder assignContactCategoryAction(AssignContactCategoryActionDefinition var1);

        default public Builder assignContactCategoryAction(Consumer<AssignContactCategoryActionDefinition.Builder> assignContactCategoryAction) {
            return this.assignContactCategoryAction((AssignContactCategoryActionDefinition)((AssignContactCategoryActionDefinition.Builder)AssignContactCategoryActionDefinition.builder().applyMutation(assignContactCategoryAction)).build());
        }

        public Builder sendNotificationAction(SendNotificationActionDefinition var1);

        default public Builder sendNotificationAction(Consumer<SendNotificationActionDefinition.Builder> sendNotificationAction) {
            return this.sendNotificationAction((SendNotificationActionDefinition)((SendNotificationActionDefinition.Builder)SendNotificationActionDefinition.builder().applyMutation(sendNotificationAction)).build());
        }
    }
}

