/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.SecurityProfileSearchCriteria;
import software.amazon.awssdk.services.connect.model.SecurityProfilesSearchFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchSecurityProfilesRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, SearchSecurityProfilesRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(SearchSecurityProfilesRequest.getter(SearchSecurityProfilesRequest::instanceId)).setter(SearchSecurityProfilesRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SearchSecurityProfilesRequest.getter(SearchSecurityProfilesRequest::nextToken)).setter(SearchSecurityProfilesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(SearchSecurityProfilesRequest.getter(SearchSecurityProfilesRequest::maxResults)).setter(SearchSecurityProfilesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<SecurityProfileSearchCriteria> SEARCH_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SearchCriteria").getter(SearchSecurityProfilesRequest.getter(SearchSecurityProfilesRequest::searchCriteria)).setter(SearchSecurityProfilesRequest.setter(Builder::searchCriteria)).constructor(SecurityProfileSearchCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchCriteria").build()}).build();
    private static final SdkField<SecurityProfilesSearchFilter> SEARCH_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SearchFilter").getter(SearchSecurityProfilesRequest.getter(SearchSecurityProfilesRequest::searchFilter)).setter(SearchSecurityProfilesRequest.setter(Builder::searchFilter)).constructor(SecurityProfilesSearchFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchFilter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, SEARCH_CRITERIA_FIELD, SEARCH_FILTER_FIELD));
    private final String instanceId;
    private final String nextToken;
    private final Integer maxResults;
    private final SecurityProfileSearchCriteria searchCriteria;
    private final SecurityProfilesSearchFilter searchFilter;

    private SearchSecurityProfilesRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.searchCriteria = builder.searchCriteria;
        this.searchFilter = builder.searchFilter;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final SecurityProfileSearchCriteria searchCriteria() {
        return this.searchCriteria;
    }

    public final SecurityProfilesSearchFilter searchFilter() {
        return this.searchFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchFilter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchSecurityProfilesRequest)) {
            return false;
        }
        SearchSecurityProfilesRequest other = (SearchSecurityProfilesRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.searchCriteria(), other.searchCriteria()) && Objects.equals(this.searchFilter(), other.searchFilter());
    }

    public final String toString() {
        return ToString.builder((String)"SearchSecurityProfilesRequest").add("InstanceId", (Object)this.instanceId()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("SearchCriteria", (Object)this.searchCriteria()).add("SearchFilter", (Object)this.searchFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "SearchCriteria": {
                return Optional.ofNullable(clazz.cast(this.searchCriteria()));
            }
            case "SearchFilter": {
                return Optional.ofNullable(clazz.cast(this.searchFilter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchSecurityProfilesRequest, T> g) {
        return obj -> g.apply((SearchSecurityProfilesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String nextToken;
        private Integer maxResults;
        private SecurityProfileSearchCriteria searchCriteria;
        private SecurityProfilesSearchFilter searchFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchSecurityProfilesRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.searchCriteria(model.searchCriteria);
            this.searchFilter(model.searchFilter);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final SecurityProfileSearchCriteria.Builder getSearchCriteria() {
            return this.searchCriteria != null ? this.searchCriteria.toBuilder() : null;
        }

        public final void setSearchCriteria(SecurityProfileSearchCriteria.BuilderImpl searchCriteria) {
            this.searchCriteria = searchCriteria != null ? searchCriteria.build() : null;
        }

        @Override
        public final Builder searchCriteria(SecurityProfileSearchCriteria searchCriteria) {
            this.searchCriteria = searchCriteria;
            return this;
        }

        public final SecurityProfilesSearchFilter.Builder getSearchFilter() {
            return this.searchFilter != null ? this.searchFilter.toBuilder() : null;
        }

        public final void setSearchFilter(SecurityProfilesSearchFilter.BuilderImpl searchFilter) {
            this.searchFilter = searchFilter != null ? searchFilter.build() : null;
        }

        @Override
        public final Builder searchFilter(SecurityProfilesSearchFilter searchFilter) {
            this.searchFilter = searchFilter;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchSecurityProfilesRequest build() {
            return new SearchSecurityProfilesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchSecurityProfilesRequest> {
        public Builder instanceId(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder searchCriteria(SecurityProfileSearchCriteria var1);

        default public Builder searchCriteria(Consumer<SecurityProfileSearchCriteria.Builder> searchCriteria) {
            return this.searchCriteria((SecurityProfileSearchCriteria)((SecurityProfileSearchCriteria.Builder)SecurityProfileSearchCriteria.builder().applyMutation(searchCriteria)).build());
        }

        public Builder searchFilter(SecurityProfilesSearchFilter var1);

        default public Builder searchFilter(Consumer<SecurityProfilesSearchFilter.Builder> searchFilter) {
            return this.searchFilter((SecurityProfilesSearchFilter)((SecurityProfilesSearchFilter.Builder)SecurityProfilesSearchFilter.builder().applyMutation(searchFilter)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

