/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateEvaluationFormRequest extends ConnectRequest implements
        ToCopyableBuilder<UpdateEvaluationFormRequest.Builder, UpdateEvaluationFormRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(UpdateEvaluationFormRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> EVALUATION_FORM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EvaluationFormId").getter(getter(UpdateEvaluationFormRequest::evaluationFormId))
            .setter(setter(Builder::evaluationFormId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("EvaluationFormId").build()).build();

    private static final SdkField<Integer> EVALUATION_FORM_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EvaluationFormVersion").getter(getter(UpdateEvaluationFormRequest::evaluationFormVersion))
            .setter(setter(Builder::evaluationFormVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationFormVersion").build())
            .build();

    private static final SdkField<Boolean> CREATE_NEW_VERSION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CreateNewVersion").getter(getter(UpdateEvaluationFormRequest::createNewVersion))
            .setter(setter(Builder::createNewVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateNewVersion").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(UpdateEvaluationFormRequest::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateEvaluationFormRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<EvaluationFormItem>> ITEMS_FIELD = SdkField
            .<List<EvaluationFormItem>> builder(MarshallingType.LIST)
            .memberName("Items")
            .getter(getter(UpdateEvaluationFormRequest::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EvaluationFormItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(EvaluationFormItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<EvaluationFormScoringStrategy> SCORING_STRATEGY_FIELD = SdkField
            .<EvaluationFormScoringStrategy> builder(MarshallingType.SDK_POJO).memberName("ScoringStrategy")
            .getter(getter(UpdateEvaluationFormRequest::scoringStrategy)).setter(setter(Builder::scoringStrategy))
            .constructor(EvaluationFormScoringStrategy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScoringStrategy").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(UpdateEvaluationFormRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            EVALUATION_FORM_ID_FIELD, EVALUATION_FORM_VERSION_FIELD, CREATE_NEW_VERSION_FIELD, TITLE_FIELD, DESCRIPTION_FIELD,
            ITEMS_FIELD, SCORING_STRATEGY_FIELD, CLIENT_TOKEN_FIELD));

    private final String instanceId;

    private final String evaluationFormId;

    private final Integer evaluationFormVersion;

    private final Boolean createNewVersion;

    private final String title;

    private final String description;

    private final List<EvaluationFormItem> items;

    private final EvaluationFormScoringStrategy scoringStrategy;

    private final String clientToken;

    private UpdateEvaluationFormRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.evaluationFormId = builder.evaluationFormId;
        this.evaluationFormVersion = builder.evaluationFormVersion;
        this.createNewVersion = builder.createNewVersion;
        this.title = builder.title;
        this.description = builder.description;
        this.items = builder.items;
        this.scoringStrategy = builder.scoringStrategy;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The unique identifier for the evaluation form.
     * </p>
     * 
     * @return The unique identifier for the evaluation form.
     */
    public final String evaluationFormId() {
        return evaluationFormId;
    }

    /**
     * <p>
     * A version of the evaluation form to update.
     * </p>
     * 
     * @return A version of the evaluation form to update.
     */
    public final Integer evaluationFormVersion() {
        return evaluationFormVersion;
    }

    /**
     * <p>
     * A flag indicating whether the operation must create a new version.
     * </p>
     * 
     * @return A flag indicating whether the operation must create a new version.
     */
    public final Boolean createNewVersion() {
        return createNewVersion;
    }

    /**
     * <p>
     * A title of the evaluation form.
     * </p>
     * 
     * @return A title of the evaluation form.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The description of the evaluation form.
     * </p>
     * 
     * @return The description of the evaluation form.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Items property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Items that are part of the evaluation form. The total number of sections and questions must not exceed 100 each.
     * Questions must be contained in a section.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItems} method.
     * </p>
     * 
     * @return Items that are part of the evaluation form. The total number of sections and questions must not exceed
     *         100 each. Questions must be contained in a section.
     */
    public final List<EvaluationFormItem> items() {
        return items;
    }

    /**
     * <p>
     * A scoring strategy of the evaluation form.
     * </p>
     * 
     * @return A scoring strategy of the evaluation form.
     */
    public final EvaluationFormScoringStrategy scoringStrategy() {
        return scoringStrategy;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided,
     * the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
     * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with
     * idempotent APIs</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
     *         provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see
     *         <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
     *         retries safe with idempotent APIs</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationFormId());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationFormVersion());
        hashCode = 31 * hashCode + Objects.hashCode(createNewVersion());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasItems() ? items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(scoringStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEvaluationFormRequest)) {
            return false;
        }
        UpdateEvaluationFormRequest other = (UpdateEvaluationFormRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(evaluationFormId(), other.evaluationFormId())
                && Objects.equals(evaluationFormVersion(), other.evaluationFormVersion())
                && Objects.equals(createNewVersion(), other.createNewVersion()) && Objects.equals(title(), other.title())
                && Objects.equals(description(), other.description()) && hasItems() == other.hasItems()
                && Objects.equals(items(), other.items()) && Objects.equals(scoringStrategy(), other.scoringStrategy())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateEvaluationFormRequest").add("InstanceId", instanceId())
                .add("EvaluationFormId", evaluationFormId()).add("EvaluationFormVersion", evaluationFormVersion())
                .add("CreateNewVersion", createNewVersion()).add("Title", title()).add("Description", description())
                .add("Items", hasItems() ? items() : null).add("ScoringStrategy", scoringStrategy())
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "EvaluationFormId":
            return Optional.ofNullable(clazz.cast(evaluationFormId()));
        case "EvaluationFormVersion":
            return Optional.ofNullable(clazz.cast(evaluationFormVersion()));
        case "CreateNewVersion":
            return Optional.ofNullable(clazz.cast(createNewVersion()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Items":
            return Optional.ofNullable(clazz.cast(items()));
        case "ScoringStrategy":
            return Optional.ofNullable(clazz.cast(scoringStrategy()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEvaluationFormRequest, T> g) {
        return obj -> g.apply((UpdateEvaluationFormRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateEvaluationFormRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The unique identifier for the evaluation form.
         * </p>
         * 
         * @param evaluationFormId
         *        The unique identifier for the evaluation form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationFormId(String evaluationFormId);

        /**
         * <p>
         * A version of the evaluation form to update.
         * </p>
         * 
         * @param evaluationFormVersion
         *        A version of the evaluation form to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationFormVersion(Integer evaluationFormVersion);

        /**
         * <p>
         * A flag indicating whether the operation must create a new version.
         * </p>
         * 
         * @param createNewVersion
         *        A flag indicating whether the operation must create a new version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createNewVersion(Boolean createNewVersion);

        /**
         * <p>
         * A title of the evaluation form.
         * </p>
         * 
         * @param title
         *        A title of the evaluation form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The description of the evaluation form.
         * </p>
         * 
         * @param description
         *        The description of the evaluation form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Items that are part of the evaluation form. The total number of sections and questions must not exceed 100
         * each. Questions must be contained in a section.
         * </p>
         * 
         * @param items
         *        Items that are part of the evaluation form. The total number of sections and questions must not exceed
         *        100 each. Questions must be contained in a section.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<EvaluationFormItem> items);

        /**
         * <p>
         * Items that are part of the evaluation form. The total number of sections and questions must not exceed 100
         * each. Questions must be contained in a section.
         * </p>
         * 
         * @param items
         *        Items that are part of the evaluation form. The total number of sections and questions must not exceed
         *        100 each. Questions must be contained in a section.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(EvaluationFormItem... items);

        /**
         * <p>
         * Items that are part of the evaluation form. The total number of sections and questions must not exceed 100
         * each. Questions must be contained in a section.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.EvaluationFormItem.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.connect.model.EvaluationFormItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.EvaluationFormItem.Builder#build()} is called
         * immediately and its result is passed to {@link #items(List<EvaluationFormItem>)}.
         * 
         * @param items
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.EvaluationFormItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(java.util.Collection<EvaluationFormItem>)
         */
        Builder items(Consumer<EvaluationFormItem.Builder>... items);

        /**
         * <p>
         * A scoring strategy of the evaluation form.
         * </p>
         * 
         * @param scoringStrategy
         *        A scoring strategy of the evaluation form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scoringStrategy(EvaluationFormScoringStrategy scoringStrategy);

        /**
         * <p>
         * A scoring strategy of the evaluation form.
         * </p>
         * This is a convenience method that creates an instance of the {@link EvaluationFormScoringStrategy.Builder}
         * avoiding the need to create one manually via {@link EvaluationFormScoringStrategy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluationFormScoringStrategy.Builder#build()} is called
         * immediately and its result is passed to {@link #scoringStrategy(EvaluationFormScoringStrategy)}.
         * 
         * @param scoringStrategy
         *        a consumer that will call methods on {@link EvaluationFormScoringStrategy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scoringStrategy(EvaluationFormScoringStrategy)
         */
        default Builder scoringStrategy(Consumer<EvaluationFormScoringStrategy.Builder> scoringStrategy) {
            return scoringStrategy(EvaluationFormScoringStrategy.builder().applyMutation(scoringStrategy).build());
        }

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         * provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
         * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe
         * with idempotent APIs</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         *        provided, the Amazon Web Services SDK populates this field. For more information about idempotency,
         *        see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
         *        retries safe with idempotent APIs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String evaluationFormId;

        private Integer evaluationFormVersion;

        private Boolean createNewVersion;

        private String title;

        private String description;

        private List<EvaluationFormItem> items = DefaultSdkAutoConstructList.getInstance();

        private EvaluationFormScoringStrategy scoringStrategy;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEvaluationFormRequest model) {
            super(model);
            instanceId(model.instanceId);
            evaluationFormId(model.evaluationFormId);
            evaluationFormVersion(model.evaluationFormVersion);
            createNewVersion(model.createNewVersion);
            title(model.title);
            description(model.description);
            items(model.items);
            scoringStrategy(model.scoringStrategy);
            clientToken(model.clientToken);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getEvaluationFormId() {
            return evaluationFormId;
        }

        public final void setEvaluationFormId(String evaluationFormId) {
            this.evaluationFormId = evaluationFormId;
        }

        @Override
        public final Builder evaluationFormId(String evaluationFormId) {
            this.evaluationFormId = evaluationFormId;
            return this;
        }

        public final Integer getEvaluationFormVersion() {
            return evaluationFormVersion;
        }

        public final void setEvaluationFormVersion(Integer evaluationFormVersion) {
            this.evaluationFormVersion = evaluationFormVersion;
        }

        @Override
        public final Builder evaluationFormVersion(Integer evaluationFormVersion) {
            this.evaluationFormVersion = evaluationFormVersion;
            return this;
        }

        public final Boolean getCreateNewVersion() {
            return createNewVersion;
        }

        public final void setCreateNewVersion(Boolean createNewVersion) {
            this.createNewVersion = createNewVersion;
        }

        @Override
        public final Builder createNewVersion(Boolean createNewVersion) {
            this.createNewVersion = createNewVersion;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<EvaluationFormItem.Builder> getItems() {
            List<EvaluationFormItem.Builder> result = EvaluationFormItemsListCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<EvaluationFormItem.BuilderImpl> items) {
            this.items = EvaluationFormItemsListCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<EvaluationFormItem> items) {
            this.items = EvaluationFormItemsListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(EvaluationFormItem... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<EvaluationFormItem.Builder>... items) {
            items(Stream.of(items).map(c -> EvaluationFormItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final EvaluationFormScoringStrategy.Builder getScoringStrategy() {
            return scoringStrategy != null ? scoringStrategy.toBuilder() : null;
        }

        public final void setScoringStrategy(EvaluationFormScoringStrategy.BuilderImpl scoringStrategy) {
            this.scoringStrategy = scoringStrategy != null ? scoringStrategy.build() : null;
        }

        @Override
        public final Builder scoringStrategy(EvaluationFormScoringStrategy scoringStrategy) {
            this.scoringStrategy = scoringStrategy;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEvaluationFormRequest build() {
            return new UpdateEvaluationFormRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
