/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTaskTemplateResponse extends ConnectResponse implements
        ToCopyableBuilder<GetTaskTemplateResponse.Builder, GetTaskTemplateResponse> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(GetTaskTemplateResponse::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(GetTaskTemplateResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(GetTaskTemplateResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetTaskTemplateResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GetTaskTemplateResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> CONTACT_FLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactFlowId").getter(getter(GetTaskTemplateResponse::contactFlowId))
            .setter(setter(Builder::contactFlowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactFlowId").build()).build();

    private static final SdkField<TaskTemplateConstraints> CONSTRAINTS_FIELD = SdkField
            .<TaskTemplateConstraints> builder(MarshallingType.SDK_POJO).memberName("Constraints")
            .getter(getter(GetTaskTemplateResponse::constraints)).setter(setter(Builder::constraints))
            .constructor(TaskTemplateConstraints::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Constraints").build()).build();

    private static final SdkField<TaskTemplateDefaults> DEFAULTS_FIELD = SdkField
            .<TaskTemplateDefaults> builder(MarshallingType.SDK_POJO).memberName("Defaults")
            .getter(getter(GetTaskTemplateResponse::defaults)).setter(setter(Builder::defaults))
            .constructor(TaskTemplateDefaults::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Defaults").build()).build();

    private static final SdkField<List<TaskTemplateField>> FIELDS_FIELD = SdkField
            .<List<TaskTemplateField>> builder(MarshallingType.LIST)
            .memberName("Fields")
            .getter(getter(GetTaskTemplateResponse::fields))
            .setter(setter(Builder::fields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TaskTemplateField> builder(MarshallingType.SDK_POJO)
                                            .constructor(TaskTemplateField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetTaskTemplateResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(GetTaskTemplateResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(GetTaskTemplateResponse::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(GetTaskTemplateResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, ID_FIELD,
            ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, CONTACT_FLOW_ID_FIELD, CONSTRAINTS_FIELD, DEFAULTS_FIELD, FIELDS_FIELD,
            STATUS_FIELD, LAST_MODIFIED_TIME_FIELD, CREATED_TIME_FIELD, TAGS_FIELD));

    private final String instanceId;

    private final String id;

    private final String arn;

    private final String name;

    private final String description;

    private final String contactFlowId;

    private final TaskTemplateConstraints constraints;

    private final TaskTemplateDefaults defaults;

    private final List<TaskTemplateField> fields;

    private final String status;

    private final Instant lastModifiedTime;

    private final Instant createdTime;

    private final Map<String, String> tags;

    private GetTaskTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.contactFlowId = builder.contactFlowId;
        this.constraints = builder.constraints;
        this.defaults = builder.defaults;
        this.fields = builder.fields;
        this.status = builder.status;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.createdTime = builder.createdTime;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * A unique identifier for the task template.
     * </p>
     * 
     * @return A unique identifier for the task template.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN).
     * </p>
     * 
     * @return The Amazon Resource Name (ARN).
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the task template.
     * </p>
     * 
     * @return The name of the task template.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the task template.
     * </p>
     * 
     * @return The description of the task template.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The identifier of the flow that runs by default when a task is created by referencing this template.
     * </p>
     * 
     * @return The identifier of the flow that runs by default when a task is created by referencing this template.
     */
    public final String contactFlowId() {
        return contactFlowId;
    }

    /**
     * <p>
     * Constraints that are applicable to the fields listed.
     * </p>
     * 
     * @return Constraints that are applicable to the fields listed.
     */
    public final TaskTemplateConstraints constraints() {
        return constraints;
    }

    /**
     * <p>
     * The default values for fields when a task is created by referencing this template.
     * </p>
     * 
     * @return The default values for fields when a task is created by referencing this template.
     */
    public final TaskTemplateDefaults defaults() {
        return defaults;
    }

    /**
     * For responses, this returns true if the service returned a value for the Fields property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFields() {
        return fields != null && !(fields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Fields that are part of the template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFields} method.
     * </p>
     * 
     * @return Fields that are part of the template.
     */
    public final List<TaskTemplateField> fields() {
        return fields;
    }

    /**
     * <p>
     * Marks a template as <code>ACTIVE</code> or <code>INACTIVE</code> for a task to refer to it. Tasks can only be
     * created from <code>ACTIVE</code> templates. If a template is marked as <code>INACTIVE</code>, then a task that
     * refers to this template cannot be created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TaskTemplateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Marks a template as <code>ACTIVE</code> or <code>INACTIVE</code> for a task to refer to it. Tasks can
     *         only be created from <code>ACTIVE</code> templates. If a template is marked as <code>INACTIVE</code>,
     *         then a task that refers to this template cannot be created.
     * @see TaskTemplateStatus
     */
    public final TaskTemplateStatus status() {
        return TaskTemplateStatus.fromValue(status);
    }

    /**
     * <p>
     * Marks a template as <code>ACTIVE</code> or <code>INACTIVE</code> for a task to refer to it. Tasks can only be
     * created from <code>ACTIVE</code> templates. If a template is marked as <code>INACTIVE</code>, then a task that
     * refers to this template cannot be created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TaskTemplateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Marks a template as <code>ACTIVE</code> or <code>INACTIVE</code> for a task to refer to it. Tasks can
     *         only be created from <code>ACTIVE</code> templates. If a template is marked as <code>INACTIVE</code>,
     *         then a task that refers to this template cannot be created.
     * @see TaskTemplateStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The timestamp when the task template was last modified.
     * </p>
     * 
     * @return The timestamp when the task template was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The timestamp when the task template was created.
     * </p>
     * 
     * @return The timestamp when the task template was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource. For example, { "tags": {"key1":"value1",
     * "key2":"value2"} }.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource. For example, { "tags":
     *         {"key1":"value1", "key2":"value2"} }.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(contactFlowId());
        hashCode = 31 * hashCode + Objects.hashCode(constraints());
        hashCode = 31 * hashCode + Objects.hashCode(defaults());
        hashCode = 31 * hashCode + Objects.hashCode(hasFields() ? fields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTaskTemplateResponse)) {
            return false;
        }
        GetTaskTemplateResponse other = (GetTaskTemplateResponse) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(id(), other.id())
                && Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(contactFlowId(), other.contactFlowId())
                && Objects.equals(constraints(), other.constraints()) && Objects.equals(defaults(), other.defaults())
                && hasFields() == other.hasFields() && Objects.equals(fields(), other.fields())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(createdTime(), other.createdTime()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTaskTemplateResponse").add("InstanceId", instanceId()).add("Id", id()).add("Arn", arn())
                .add("Name", name()).add("Description", description()).add("ContactFlowId", contactFlowId())
                .add("Constraints", constraints()).add("Defaults", defaults()).add("Fields", hasFields() ? fields() : null)
                .add("Status", statusAsString()).add("LastModifiedTime", lastModifiedTime()).add("CreatedTime", createdTime())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ContactFlowId":
            return Optional.ofNullable(clazz.cast(contactFlowId()));
        case "Constraints":
            return Optional.ofNullable(clazz.cast(constraints()));
        case "Defaults":
            return Optional.ofNullable(clazz.cast(defaults()));
        case "Fields":
            return Optional.ofNullable(clazz.cast(fields()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTaskTemplateResponse, T> g) {
        return obj -> g.apply((GetTaskTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetTaskTemplateResponse> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * A unique identifier for the task template.
         * </p>
         * 
         * @param id
         *        A unique identifier for the task template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN).
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the task template.
         * </p>
         * 
         * @param name
         *        The name of the task template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the task template.
         * </p>
         * 
         * @param description
         *        The description of the task template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The identifier of the flow that runs by default when a task is created by referencing this template.
         * </p>
         * 
         * @param contactFlowId
         *        The identifier of the flow that runs by default when a task is created by referencing this template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactFlowId(String contactFlowId);

        /**
         * <p>
         * Constraints that are applicable to the fields listed.
         * </p>
         * 
         * @param constraints
         *        Constraints that are applicable to the fields listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder constraints(TaskTemplateConstraints constraints);

        /**
         * <p>
         * Constraints that are applicable to the fields listed.
         * </p>
         * This is a convenience method that creates an instance of the {@link TaskTemplateConstraints.Builder} avoiding
         * the need to create one manually via {@link TaskTemplateConstraints#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TaskTemplateConstraints.Builder#build()} is called immediately
         * and its result is passed to {@link #constraints(TaskTemplateConstraints)}.
         * 
         * @param constraints
         *        a consumer that will call methods on {@link TaskTemplateConstraints.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #constraints(TaskTemplateConstraints)
         */
        default Builder constraints(Consumer<TaskTemplateConstraints.Builder> constraints) {
            return constraints(TaskTemplateConstraints.builder().applyMutation(constraints).build());
        }

        /**
         * <p>
         * The default values for fields when a task is created by referencing this template.
         * </p>
         * 
         * @param defaults
         *        The default values for fields when a task is created by referencing this template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaults(TaskTemplateDefaults defaults);

        /**
         * <p>
         * The default values for fields when a task is created by referencing this template.
         * </p>
         * This is a convenience method that creates an instance of the {@link TaskTemplateDefaults.Builder} avoiding
         * the need to create one manually via {@link TaskTemplateDefaults#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TaskTemplateDefaults.Builder#build()} is called immediately and
         * its result is passed to {@link #defaults(TaskTemplateDefaults)}.
         * 
         * @param defaults
         *        a consumer that will call methods on {@link TaskTemplateDefaults.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaults(TaskTemplateDefaults)
         */
        default Builder defaults(Consumer<TaskTemplateDefaults.Builder> defaults) {
            return defaults(TaskTemplateDefaults.builder().applyMutation(defaults).build());
        }

        /**
         * <p>
         * Fields that are part of the template.
         * </p>
         * 
         * @param fields
         *        Fields that are part of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(Collection<TaskTemplateField> fields);

        /**
         * <p>
         * Fields that are part of the template.
         * </p>
         * 
         * @param fields
         *        Fields that are part of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(TaskTemplateField... fields);

        /**
         * <p>
         * Fields that are part of the template.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.TaskTemplateField.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.connect.model.TaskTemplateField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.TaskTemplateField.Builder#build()} is called immediately
         * and its result is passed to {@link #fields(List<TaskTemplateField>)}.
         * 
         * @param fields
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.TaskTemplateField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fields(java.util.Collection<TaskTemplateField>)
         */
        Builder fields(Consumer<TaskTemplateField.Builder>... fields);

        /**
         * <p>
         * Marks a template as <code>ACTIVE</code> or <code>INACTIVE</code> for a task to refer to it. Tasks can only be
         * created from <code>ACTIVE</code> templates. If a template is marked as <code>INACTIVE</code>, then a task
         * that refers to this template cannot be created.
         * </p>
         * 
         * @param status
         *        Marks a template as <code>ACTIVE</code> or <code>INACTIVE</code> for a task to refer to it. Tasks can
         *        only be created from <code>ACTIVE</code> templates. If a template is marked as <code>INACTIVE</code>,
         *        then a task that refers to this template cannot be created.
         * @see TaskTemplateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskTemplateStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Marks a template as <code>ACTIVE</code> or <code>INACTIVE</code> for a task to refer to it. Tasks can only be
         * created from <code>ACTIVE</code> templates. If a template is marked as <code>INACTIVE</code>, then a task
         * that refers to this template cannot be created.
         * </p>
         * 
         * @param status
         *        Marks a template as <code>ACTIVE</code> or <code>INACTIVE</code> for a task to refer to it. Tasks can
         *        only be created from <code>ACTIVE</code> templates. If a template is marked as <code>INACTIVE</code>,
         *        then a task that refers to this template cannot be created.
         * @see TaskTemplateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskTemplateStatus
         */
        Builder status(TaskTemplateStatus status);

        /**
         * <p>
         * The timestamp when the task template was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The timestamp when the task template was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The timestamp when the task template was created.
         * </p>
         * 
         * @param createdTime
         *        The timestamp when the task template was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource. For example, { "tags":
         * {"key1":"value1", "key2":"value2"} }.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource. For example, { "tags":
         *        {"key1":"value1", "key2":"value2"} }.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private String instanceId;

        private String id;

        private String arn;

        private String name;

        private String description;

        private String contactFlowId;

        private TaskTemplateConstraints constraints;

        private TaskTemplateDefaults defaults;

        private List<TaskTemplateField> fields = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private Instant lastModifiedTime;

        private Instant createdTime;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetTaskTemplateResponse model) {
            super(model);
            instanceId(model.instanceId);
            id(model.id);
            arn(model.arn);
            name(model.name);
            description(model.description);
            contactFlowId(model.contactFlowId);
            constraints(model.constraints);
            defaults(model.defaults);
            fields(model.fields);
            status(model.status);
            lastModifiedTime(model.lastModifiedTime);
            createdTime(model.createdTime);
            tags(model.tags);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getContactFlowId() {
            return contactFlowId;
        }

        public final void setContactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
        }

        @Override
        public final Builder contactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
            return this;
        }

        public final TaskTemplateConstraints.Builder getConstraints() {
            return constraints != null ? constraints.toBuilder() : null;
        }

        public final void setConstraints(TaskTemplateConstraints.BuilderImpl constraints) {
            this.constraints = constraints != null ? constraints.build() : null;
        }

        @Override
        public final Builder constraints(TaskTemplateConstraints constraints) {
            this.constraints = constraints;
            return this;
        }

        public final TaskTemplateDefaults.Builder getDefaults() {
            return defaults != null ? defaults.toBuilder() : null;
        }

        public final void setDefaults(TaskTemplateDefaults.BuilderImpl defaults) {
            this.defaults = defaults != null ? defaults.build() : null;
        }

        @Override
        public final Builder defaults(TaskTemplateDefaults defaults) {
            this.defaults = defaults;
            return this;
        }

        public final List<TaskTemplateField.Builder> getFields() {
            List<TaskTemplateField.Builder> result = TaskTemplateFieldsCopier.copyToBuilder(this.fields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFields(Collection<TaskTemplateField.BuilderImpl> fields) {
            this.fields = TaskTemplateFieldsCopier.copyFromBuilder(fields);
        }

        @Override
        public final Builder fields(Collection<TaskTemplateField> fields) {
            this.fields = TaskTemplateFieldsCopier.copy(fields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(TaskTemplateField... fields) {
            fields(Arrays.asList(fields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(Consumer<TaskTemplateField.Builder>... fields) {
            fields(Stream.of(fields).map(c -> TaskTemplateField.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TaskTemplateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetTaskTemplateResponse build() {
            return new GetTaskTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
