/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.InstanceSummary;
import software.amazon.awssdk.services.connect.model.InstanceSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListInstancesResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, ListInstancesResponse> {
    private static final SdkField<List<InstanceSummary>> INSTANCE_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceSummaryList").getter(ListInstancesResponse.getter(ListInstancesResponse::instanceSummaryList)).setter(ListInstancesResponse.setter(Builder::instanceSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListInstancesResponse.getter(ListInstancesResponse::nextToken)).setter(ListInstancesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<InstanceSummary> instanceSummaryList;
    private final String nextToken;

    private ListInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.instanceSummaryList = builder.instanceSummaryList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasInstanceSummaryList() {
        return this.instanceSummaryList != null && !(this.instanceSummaryList instanceof SdkAutoConstructList);
    }

    public final List<InstanceSummary> instanceSummaryList() {
        return this.instanceSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceSummaryList() ? this.instanceSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInstancesResponse)) {
            return false;
        }
        ListInstancesResponse other = (ListInstancesResponse)((Object)obj);
        return this.hasInstanceSummaryList() == other.hasInstanceSummaryList() && Objects.equals(this.instanceSummaryList(), other.instanceSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListInstancesResponse").add("InstanceSummaryList", this.hasInstanceSummaryList() ? this.instanceSummaryList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceSummaryList": {
                return Optional.ofNullable(clazz.cast(this.instanceSummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListInstancesResponse, T> g) {
        return obj -> g.apply((ListInstancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<InstanceSummary> instanceSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInstancesResponse model) {
            super(model);
            this.instanceSummaryList(model.instanceSummaryList);
            this.nextToken(model.nextToken);
        }

        public final List<InstanceSummary.Builder> getInstanceSummaryList() {
            List<InstanceSummary.Builder> result = InstanceSummaryListCopier.copyToBuilder(this.instanceSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceSummaryList(Collection<InstanceSummary.BuilderImpl> instanceSummaryList) {
            this.instanceSummaryList = InstanceSummaryListCopier.copyFromBuilder(instanceSummaryList);
        }

        @Override
        public final Builder instanceSummaryList(Collection<InstanceSummary> instanceSummaryList) {
            this.instanceSummaryList = InstanceSummaryListCopier.copy(instanceSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceSummaryList(InstanceSummary ... instanceSummaryList) {
            this.instanceSummaryList(Arrays.asList(instanceSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceSummaryList(Consumer<InstanceSummary.Builder> ... instanceSummaryList) {
            this.instanceSummaryList(Stream.of(instanceSummaryList).map(c -> (InstanceSummary)((InstanceSummary.Builder)InstanceSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListInstancesResponse build() {
            return new ListInstancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListInstancesResponse> {
        public Builder instanceSummaryList(Collection<InstanceSummary> var1);

        public Builder instanceSummaryList(InstanceSummary ... var1);

        public Builder instanceSummaryList(Consumer<InstanceSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

