/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.model.ListRulesRequest;
import software.amazon.awssdk.services.connect.model.ListRulesResponse;
import software.amazon.awssdk.services.connect.model.RuleSummary;

public class ListRulesPublisher
implements SdkPublisher<ListRulesResponse> {
    private final ConnectAsyncClient client;
    private final ListRulesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRulesPublisher(ConnectAsyncClient client, ListRulesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRulesPublisher(ConnectAsyncClient client, ListRulesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRulesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRulesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RuleSummary> ruleSummaryList() {
        Function<ListRulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.ruleSummaryList() != null) {
                return response.ruleSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRulesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRulesResponseFetcher
    implements AsyncPageFetcher<ListRulesResponse> {
        private ListRulesResponseFetcher() {
        }

        public boolean hasNextPage(ListRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRulesResponse> nextPage(ListRulesResponse previousPage) {
            if (previousPage == null) {
                return ListRulesPublisher.this.client.listRules(ListRulesPublisher.this.firstRequest);
            }
            return ListRulesPublisher.this.client.listRules((ListRulesRequest)((Object)ListRulesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

