/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.HoursOfOperationConfig;
import software.amazon.awssdk.services.connect.model.HoursOfOperationConfigListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateHoursOfOperationRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, UpdateHoursOfOperationRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(UpdateHoursOfOperationRequest.getter(UpdateHoursOfOperationRequest::instanceId)).setter(UpdateHoursOfOperationRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<String> HOURS_OF_OPERATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HoursOfOperationId").getter(UpdateHoursOfOperationRequest.getter(UpdateHoursOfOperationRequest::hoursOfOperationId)).setter(UpdateHoursOfOperationRequest.setter(Builder::hoursOfOperationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("HoursOfOperationId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateHoursOfOperationRequest.getter(UpdateHoursOfOperationRequest::name)).setter(UpdateHoursOfOperationRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateHoursOfOperationRequest.getter(UpdateHoursOfOperationRequest::description)).setter(UpdateHoursOfOperationRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> TIME_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimeZone").getter(UpdateHoursOfOperationRequest.getter(UpdateHoursOfOperationRequest::timeZone)).setter(UpdateHoursOfOperationRequest.setter(Builder::timeZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeZone").build()}).build();
    private static final SdkField<List<HoursOfOperationConfig>> CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Config").getter(UpdateHoursOfOperationRequest.getter(UpdateHoursOfOperationRequest::config)).setter(UpdateHoursOfOperationRequest.setter(Builder::config)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Config").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HoursOfOperationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, HOURS_OF_OPERATION_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, TIME_ZONE_FIELD, CONFIG_FIELD));
    private final String instanceId;
    private final String hoursOfOperationId;
    private final String name;
    private final String description;
    private final String timeZone;
    private final List<HoursOfOperationConfig> config;

    private UpdateHoursOfOperationRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.hoursOfOperationId = builder.hoursOfOperationId;
        this.name = builder.name;
        this.description = builder.description;
        this.timeZone = builder.timeZone;
        this.config = builder.config;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String hoursOfOperationId() {
        return this.hoursOfOperationId;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String timeZone() {
        return this.timeZone;
    }

    public final boolean hasConfig() {
        return this.config != null && !(this.config instanceof SdkAutoConstructList);
    }

    public final List<HoursOfOperationConfig> config() {
        return this.config;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hoursOfOperationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfig() ? this.config() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateHoursOfOperationRequest)) {
            return false;
        }
        UpdateHoursOfOperationRequest other = (UpdateHoursOfOperationRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.hoursOfOperationId(), other.hoursOfOperationId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.timeZone(), other.timeZone()) && this.hasConfig() == other.hasConfig() && Objects.equals(this.config(), other.config());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateHoursOfOperationRequest").add("InstanceId", (Object)this.instanceId()).add("HoursOfOperationId", (Object)this.hoursOfOperationId()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("TimeZone", (Object)this.timeZone()).add("Config", this.hasConfig() ? this.config() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "HoursOfOperationId": {
                return Optional.ofNullable(clazz.cast(this.hoursOfOperationId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "TimeZone": {
                return Optional.ofNullable(clazz.cast(this.timeZone()));
            }
            case "Config": {
                return Optional.ofNullable(clazz.cast(this.config()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateHoursOfOperationRequest, T> g) {
        return obj -> g.apply((UpdateHoursOfOperationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String hoursOfOperationId;
        private String name;
        private String description;
        private String timeZone;
        private List<HoursOfOperationConfig> config = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateHoursOfOperationRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.hoursOfOperationId(model.hoursOfOperationId);
            this.name(model.name);
            this.description(model.description);
            this.timeZone(model.timeZone);
            this.config(model.config);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        @Transient
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getHoursOfOperationId() {
            return this.hoursOfOperationId;
        }

        public final void setHoursOfOperationId(String hoursOfOperationId) {
            this.hoursOfOperationId = hoursOfOperationId;
        }

        @Override
        @Transient
        public final Builder hoursOfOperationId(String hoursOfOperationId) {
            this.hoursOfOperationId = hoursOfOperationId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getTimeZone() {
            return this.timeZone;
        }

        public final void setTimeZone(String timeZone) {
            this.timeZone = timeZone;
        }

        @Override
        @Transient
        public final Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public final List<HoursOfOperationConfig.Builder> getConfig() {
            List<HoursOfOperationConfig.Builder> result = HoursOfOperationConfigListCopier.copyToBuilder(this.config);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfig(Collection<HoursOfOperationConfig.BuilderImpl> config) {
            this.config = HoursOfOperationConfigListCopier.copyFromBuilder(config);
        }

        @Override
        @Transient
        public final Builder config(Collection<HoursOfOperationConfig> config) {
            this.config = HoursOfOperationConfigListCopier.copy(config);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder config(HoursOfOperationConfig ... config) {
            this.config(Arrays.asList(config));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder config(Consumer<HoursOfOperationConfig.Builder> ... config) {
            this.config(Stream.of(config).map(c -> (HoursOfOperationConfig)((HoursOfOperationConfig.Builder)HoursOfOperationConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateHoursOfOperationRequest build() {
            return new UpdateHoursOfOperationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateHoursOfOperationRequest> {
        public Builder instanceId(String var1);

        public Builder hoursOfOperationId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder timeZone(String var1);

        public Builder config(Collection<HoursOfOperationConfig> var1);

        public Builder config(HoursOfOperationConfig ... var1);

        public Builder config(Consumer<HoursOfOperationConfig.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

