/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.QueueType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueueReference
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QueueReference> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(QueueReference.getter(QueueReference::id)).setter(QueueReference.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(QueueReference.getter(QueueReference::arn)).setter(QueueReference.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> QUEUE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueueType").getter(QueueReference.getter(QueueReference::queueTypeAsString)).setter(QueueReference.setter(Builder::queueType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, QUEUE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String arn;
    private final String queueType;

    private QueueReference(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.queueType = builder.queueType;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final QueueType queueType() {
        return QueueType.fromValue(this.queueType);
    }

    public final String queueTypeAsString() {
        return this.queueType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueueReference)) {
            return false;
        }
        QueueReference other = (QueueReference)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.queueTypeAsString(), other.queueTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"QueueReference").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("QueueType", (Object)this.queueTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "QueueType": {
                return Optional.ofNullable(clazz.cast(this.queueTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueueReference, T> g) {
        return obj -> g.apply((QueueReference)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String queueType;

        private BuilderImpl() {
        }

        private BuilderImpl(QueueReference model) {
            this.id(model.id);
            this.arn(model.arn);
            this.queueType(model.queueType);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getQueueType() {
            return this.queueType;
        }

        public final void setQueueType(String queueType) {
            this.queueType = queueType;
        }

        @Override
        @Transient
        public final Builder queueType(String queueType) {
            this.queueType = queueType;
            return this;
        }

        @Override
        @Transient
        public final Builder queueType(QueueType queueType) {
            this.queueType(queueType == null ? null : queueType.toString());
            return this;
        }

        public QueueReference build() {
            return new QueueReference(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QueueReference> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder queueType(String var1);

        public Builder queueType(QueueType var1);
    }
}

