/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.PhoneNumberQuickConnectConfig;
import software.amazon.awssdk.services.connect.model.QueueQuickConnectConfig;
import software.amazon.awssdk.services.connect.model.QuickConnectType;
import software.amazon.awssdk.services.connect.model.UserQuickConnectConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QuickConnectConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QuickConnectConfig> {
    private static final SdkField<String> QUICK_CONNECT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuickConnectType").getter(QuickConnectConfig.getter(QuickConnectConfig::quickConnectTypeAsString)).setter(QuickConnectConfig.setter(Builder::quickConnectType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuickConnectType").build()}).build();
    private static final SdkField<UserQuickConnectConfig> USER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UserConfig").getter(QuickConnectConfig.getter(QuickConnectConfig::userConfig)).setter(QuickConnectConfig.setter(Builder::userConfig)).constructor(UserQuickConnectConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserConfig").build()}).build();
    private static final SdkField<QueueQuickConnectConfig> QUEUE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("QueueConfig").getter(QuickConnectConfig.getter(QuickConnectConfig::queueConfig)).setter(QuickConnectConfig.setter(Builder::queueConfig)).constructor(QueueQuickConnectConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueConfig").build()}).build();
    private static final SdkField<PhoneNumberQuickConnectConfig> PHONE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PhoneConfig").getter(QuickConnectConfig.getter(QuickConnectConfig::phoneConfig)).setter(QuickConnectConfig.setter(Builder::phoneConfig)).constructor(PhoneNumberQuickConnectConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUICK_CONNECT_TYPE_FIELD, USER_CONFIG_FIELD, QUEUE_CONFIG_FIELD, PHONE_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String quickConnectType;
    private final UserQuickConnectConfig userConfig;
    private final QueueQuickConnectConfig queueConfig;
    private final PhoneNumberQuickConnectConfig phoneConfig;

    private QuickConnectConfig(BuilderImpl builder) {
        this.quickConnectType = builder.quickConnectType;
        this.userConfig = builder.userConfig;
        this.queueConfig = builder.queueConfig;
        this.phoneConfig = builder.phoneConfig;
    }

    public final QuickConnectType quickConnectType() {
        return QuickConnectType.fromValue(this.quickConnectType);
    }

    public final String quickConnectTypeAsString() {
        return this.quickConnectType;
    }

    public final UserQuickConnectConfig userConfig() {
        return this.userConfig;
    }

    public final QueueQuickConnectConfig queueConfig() {
        return this.queueConfig;
    }

    public final PhoneNumberQuickConnectConfig phoneConfig() {
        return this.phoneConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.quickConnectTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.userConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuickConnectConfig)) {
            return false;
        }
        QuickConnectConfig other = (QuickConnectConfig)obj;
        return Objects.equals(this.quickConnectTypeAsString(), other.quickConnectTypeAsString()) && Objects.equals(this.userConfig(), other.userConfig()) && Objects.equals(this.queueConfig(), other.queueConfig()) && Objects.equals(this.phoneConfig(), other.phoneConfig());
    }

    public final String toString() {
        return ToString.builder((String)"QuickConnectConfig").add("QuickConnectType", (Object)this.quickConnectTypeAsString()).add("UserConfig", (Object)this.userConfig()).add("QueueConfig", (Object)this.queueConfig()).add("PhoneConfig", (Object)this.phoneConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QuickConnectType": {
                return Optional.ofNullable(clazz.cast(this.quickConnectTypeAsString()));
            }
            case "UserConfig": {
                return Optional.ofNullable(clazz.cast(this.userConfig()));
            }
            case "QueueConfig": {
                return Optional.ofNullable(clazz.cast(this.queueConfig()));
            }
            case "PhoneConfig": {
                return Optional.ofNullable(clazz.cast(this.phoneConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QuickConnectConfig, T> g) {
        return obj -> g.apply((QuickConnectConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String quickConnectType;
        private UserQuickConnectConfig userConfig;
        private QueueQuickConnectConfig queueConfig;
        private PhoneNumberQuickConnectConfig phoneConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(QuickConnectConfig model) {
            this.quickConnectType(model.quickConnectType);
            this.userConfig(model.userConfig);
            this.queueConfig(model.queueConfig);
            this.phoneConfig(model.phoneConfig);
        }

        public final String getQuickConnectType() {
            return this.quickConnectType;
        }

        public final void setQuickConnectType(String quickConnectType) {
            this.quickConnectType = quickConnectType;
        }

        @Override
        @Transient
        public final Builder quickConnectType(String quickConnectType) {
            this.quickConnectType = quickConnectType;
            return this;
        }

        @Override
        @Transient
        public final Builder quickConnectType(QuickConnectType quickConnectType) {
            this.quickConnectType(quickConnectType == null ? null : quickConnectType.toString());
            return this;
        }

        public final UserQuickConnectConfig.Builder getUserConfig() {
            return this.userConfig != null ? this.userConfig.toBuilder() : null;
        }

        public final void setUserConfig(UserQuickConnectConfig.BuilderImpl userConfig) {
            this.userConfig = userConfig != null ? userConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder userConfig(UserQuickConnectConfig userConfig) {
            this.userConfig = userConfig;
            return this;
        }

        public final QueueQuickConnectConfig.Builder getQueueConfig() {
            return this.queueConfig != null ? this.queueConfig.toBuilder() : null;
        }

        public final void setQueueConfig(QueueQuickConnectConfig.BuilderImpl queueConfig) {
            this.queueConfig = queueConfig != null ? queueConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder queueConfig(QueueQuickConnectConfig queueConfig) {
            this.queueConfig = queueConfig;
            return this;
        }

        public final PhoneNumberQuickConnectConfig.Builder getPhoneConfig() {
            return this.phoneConfig != null ? this.phoneConfig.toBuilder() : null;
        }

        public final void setPhoneConfig(PhoneNumberQuickConnectConfig.BuilderImpl phoneConfig) {
            this.phoneConfig = phoneConfig != null ? phoneConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder phoneConfig(PhoneNumberQuickConnectConfig phoneConfig) {
            this.phoneConfig = phoneConfig;
            return this;
        }

        public QuickConnectConfig build() {
            return new QuickConnectConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QuickConnectConfig> {
        public Builder quickConnectType(String var1);

        public Builder quickConnectType(QuickConnectType var1);

        public Builder userConfig(UserQuickConnectConfig var1);

        default public Builder userConfig(Consumer<UserQuickConnectConfig.Builder> userConfig) {
            return this.userConfig((UserQuickConnectConfig)((UserQuickConnectConfig.Builder)UserQuickConnectConfig.builder().applyMutation(userConfig)).build());
        }

        public Builder queueConfig(QueueQuickConnectConfig var1);

        default public Builder queueConfig(Consumer<QueueQuickConnectConfig.Builder> queueConfig) {
            return this.queueConfig((QueueQuickConnectConfig)((QueueQuickConnectConfig.Builder)QueueQuickConnectConfig.builder().applyMutation(queueConfig)).build());
        }

        public Builder phoneConfig(PhoneNumberQuickConnectConfig var1);

        default public Builder phoneConfig(Consumer<PhoneNumberQuickConnectConfig.Builder> phoneConfig) {
            return this.phoneConfig((PhoneNumberQuickConnectConfig)((PhoneNumberQuickConnectConfig.Builder)PhoneNumberQuickConnectConfig.builder().applyMutation(phoneConfig)).build());
        }
    }
}

