/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.model.DefaultVocabulary;
import software.amazon.awssdk.services.connect.model.ListDefaultVocabulariesRequest;
import software.amazon.awssdk.services.connect.model.ListDefaultVocabulariesResponse;

public class ListDefaultVocabulariesPublisher
implements SdkPublisher<ListDefaultVocabulariesResponse> {
    private final ConnectAsyncClient client;
    private final ListDefaultVocabulariesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDefaultVocabulariesPublisher(ConnectAsyncClient client, ListDefaultVocabulariesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDefaultVocabulariesPublisher(ConnectAsyncClient client, ListDefaultVocabulariesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDefaultVocabulariesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDefaultVocabulariesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DefaultVocabulary> defaultVocabularyList() {
        Function<ListDefaultVocabulariesResponse, Iterator> getIterator = response -> {
            if (response != null && response.defaultVocabularyList() != null) {
                return response.defaultVocabularyList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDefaultVocabulariesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDefaultVocabulariesResponseFetcher
    implements AsyncPageFetcher<ListDefaultVocabulariesResponse> {
        private ListDefaultVocabulariesResponseFetcher() {
        }

        public boolean hasNextPage(ListDefaultVocabulariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDefaultVocabulariesResponse> nextPage(ListDefaultVocabulariesResponse previousPage) {
            if (previousPage == null) {
                return ListDefaultVocabulariesPublisher.this.client.listDefaultVocabularies(ListDefaultVocabulariesPublisher.this.firstRequest);
            }
            return ListDefaultVocabulariesPublisher.this.client.listDefaultVocabularies((ListDefaultVocabulariesRequest)((Object)ListDefaultVocabulariesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

