/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.FunctionArnsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLambdaFunctionsResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, ListLambdaFunctionsResponse> {
    private static final SdkField<List<String>> LAMBDA_FUNCTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LambdaFunctions").getter(ListLambdaFunctionsResponse.getter(ListLambdaFunctionsResponse::lambdaFunctions)).setter(ListLambdaFunctionsResponse.setter(Builder::lambdaFunctions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaFunctions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListLambdaFunctionsResponse.getter(ListLambdaFunctionsResponse::nextToken)).setter(ListLambdaFunctionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAMBDA_FUNCTIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> lambdaFunctions;
    private final String nextToken;

    private ListLambdaFunctionsResponse(BuilderImpl builder) {
        super(builder);
        this.lambdaFunctions = builder.lambdaFunctions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasLambdaFunctions() {
        return this.lambdaFunctions != null && !(this.lambdaFunctions instanceof SdkAutoConstructList);
    }

    public final List<String> lambdaFunctions() {
        return this.lambdaFunctions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLambdaFunctions() ? this.lambdaFunctions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLambdaFunctionsResponse)) {
            return false;
        }
        ListLambdaFunctionsResponse other = (ListLambdaFunctionsResponse)((Object)obj);
        return this.hasLambdaFunctions() == other.hasLambdaFunctions() && Objects.equals(this.lambdaFunctions(), other.lambdaFunctions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListLambdaFunctionsResponse").add("LambdaFunctions", this.hasLambdaFunctions() ? this.lambdaFunctions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LambdaFunctions": {
                return Optional.ofNullable(clazz.cast(this.lambdaFunctions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLambdaFunctionsResponse, T> g) {
        return obj -> g.apply((ListLambdaFunctionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<String> lambdaFunctions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLambdaFunctionsResponse model) {
            super(model);
            this.lambdaFunctions(model.lambdaFunctions);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getLambdaFunctions() {
            if (this.lambdaFunctions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.lambdaFunctions;
        }

        public final void setLambdaFunctions(Collection<String> lambdaFunctions) {
            this.lambdaFunctions = FunctionArnsListCopier.copy(lambdaFunctions);
        }

        @Override
        @Transient
        public final Builder lambdaFunctions(Collection<String> lambdaFunctions) {
            this.lambdaFunctions = FunctionArnsListCopier.copy(lambdaFunctions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder lambdaFunctions(String ... lambdaFunctions) {
            this.lambdaFunctions(Arrays.asList(lambdaFunctions));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListLambdaFunctionsResponse build() {
            return new ListLambdaFunctionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLambdaFunctionsResponse> {
        public Builder lambdaFunctions(Collection<String> var1);

        public Builder lambdaFunctions(String ... var1);

        public Builder nextToken(String var1);
    }
}

