/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ChatStreamingConfiguration;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartContactStreamingRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, StartContactStreamingRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(StartContactStreamingRequest.getter(StartContactStreamingRequest::instanceId)).setter(StartContactStreamingRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactId").getter(StartContactStreamingRequest.getter(StartContactStreamingRequest::contactId)).setter(StartContactStreamingRequest.setter(Builder::contactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactId").build()}).build();
    private static final SdkField<ChatStreamingConfiguration> CHAT_STREAMING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ChatStreamingConfiguration").getter(StartContactStreamingRequest.getter(StartContactStreamingRequest::chatStreamingConfiguration)).setter(StartContactStreamingRequest.setter(Builder::chatStreamingConfiguration)).constructor(ChatStreamingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChatStreamingConfiguration").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(StartContactStreamingRequest.getter(StartContactStreamingRequest::clientToken)).setter(StartContactStreamingRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, CONTACT_ID_FIELD, CHAT_STREAMING_CONFIGURATION_FIELD, CLIENT_TOKEN_FIELD));
    private final String instanceId;
    private final String contactId;
    private final ChatStreamingConfiguration chatStreamingConfiguration;
    private final String clientToken;

    private StartContactStreamingRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.contactId = builder.contactId;
        this.chatStreamingConfiguration = builder.chatStreamingConfiguration;
        this.clientToken = builder.clientToken;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String contactId() {
        return this.contactId;
    }

    public final ChatStreamingConfiguration chatStreamingConfiguration() {
        return this.chatStreamingConfiguration;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.chatStreamingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartContactStreamingRequest)) {
            return false;
        }
        StartContactStreamingRequest other = (StartContactStreamingRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.contactId(), other.contactId()) && Objects.equals(this.chatStreamingConfiguration(), other.chatStreamingConfiguration()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"StartContactStreamingRequest").add("InstanceId", (Object)this.instanceId()).add("ContactId", (Object)this.contactId()).add("ChatStreamingConfiguration", (Object)this.chatStreamingConfiguration()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "ContactId": {
                return Optional.ofNullable(clazz.cast(this.contactId()));
            }
            case "ChatStreamingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.chatStreamingConfiguration()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartContactStreamingRequest, T> g) {
        return obj -> g.apply((StartContactStreamingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String contactId;
        private ChatStreamingConfiguration chatStreamingConfiguration;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartContactStreamingRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.contactId(model.contactId);
            this.chatStreamingConfiguration(model.chatStreamingConfiguration);
            this.clientToken(model.clientToken);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        @Transient
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getContactId() {
            return this.contactId;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        @Override
        @Transient
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final ChatStreamingConfiguration.Builder getChatStreamingConfiguration() {
            return this.chatStreamingConfiguration != null ? this.chatStreamingConfiguration.toBuilder() : null;
        }

        public final void setChatStreamingConfiguration(ChatStreamingConfiguration.BuilderImpl chatStreamingConfiguration) {
            this.chatStreamingConfiguration = chatStreamingConfiguration != null ? chatStreamingConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder chatStreamingConfiguration(ChatStreamingConfiguration chatStreamingConfiguration) {
            this.chatStreamingConfiguration = chatStreamingConfiguration;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartContactStreamingRequest build() {
            return new StartContactStreamingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartContactStreamingRequest> {
        public Builder instanceId(String var1);

        public Builder contactId(String var1);

        public Builder chatStreamingConfiguration(ChatStreamingConfiguration var1);

        default public Builder chatStreamingConfiguration(Consumer<ChatStreamingConfiguration.Builder> chatStreamingConfiguration) {
            return this.chatStreamingConfiguration((ChatStreamingConfiguration)((ChatStreamingConfiguration.Builder)ChatStreamingConfiguration.builder().applyMutation(chatStreamingConfiguration)).build());
        }

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

