/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.RoutingProfileQueueReference;
import software.amazon.awssdk.services.connect.model.RoutingProfileQueueReferenceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisassociateRoutingProfileQueuesRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, DisassociateRoutingProfileQueuesRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(DisassociateRoutingProfileQueuesRequest.getter(DisassociateRoutingProfileQueuesRequest::instanceId)).setter(DisassociateRoutingProfileQueuesRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<String> ROUTING_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoutingProfileId").getter(DisassociateRoutingProfileQueuesRequest.getter(DisassociateRoutingProfileQueuesRequest::routingProfileId)).setter(DisassociateRoutingProfileQueuesRequest.setter(Builder::routingProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("RoutingProfileId").build()}).build();
    private static final SdkField<List<RoutingProfileQueueReference>> QUEUE_REFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("QueueReferences").getter(DisassociateRoutingProfileQueuesRequest.getter(DisassociateRoutingProfileQueuesRequest::queueReferences)).setter(DisassociateRoutingProfileQueuesRequest.setter(Builder::queueReferences)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueReferences").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RoutingProfileQueueReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, ROUTING_PROFILE_ID_FIELD, QUEUE_REFERENCES_FIELD));
    private final String instanceId;
    private final String routingProfileId;
    private final List<RoutingProfileQueueReference> queueReferences;

    private DisassociateRoutingProfileQueuesRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.routingProfileId = builder.routingProfileId;
        this.queueReferences = builder.queueReferences;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String routingProfileId() {
        return this.routingProfileId;
    }

    public final boolean hasQueueReferences() {
        return this.queueReferences != null && !(this.queueReferences instanceof SdkAutoConstructList);
    }

    public final List<RoutingProfileQueueReference> queueReferences() {
        return this.queueReferences;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQueueReferences() ? this.queueReferences() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateRoutingProfileQueuesRequest)) {
            return false;
        }
        DisassociateRoutingProfileQueuesRequest other = (DisassociateRoutingProfileQueuesRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.routingProfileId(), other.routingProfileId()) && this.hasQueueReferences() == other.hasQueueReferences() && Objects.equals(this.queueReferences(), other.queueReferences());
    }

    public final String toString() {
        return ToString.builder((String)"DisassociateRoutingProfileQueuesRequest").add("InstanceId", (Object)this.instanceId()).add("RoutingProfileId", (Object)this.routingProfileId()).add("QueueReferences", this.hasQueueReferences() ? this.queueReferences() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "RoutingProfileId": {
                return Optional.ofNullable(clazz.cast(this.routingProfileId()));
            }
            case "QueueReferences": {
                return Optional.ofNullable(clazz.cast(this.queueReferences()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateRoutingProfileQueuesRequest, T> g) {
        return obj -> g.apply((DisassociateRoutingProfileQueuesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String routingProfileId;
        private List<RoutingProfileQueueReference> queueReferences = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateRoutingProfileQueuesRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.routingProfileId(model.routingProfileId);
            this.queueReferences(model.queueReferences);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getRoutingProfileId() {
            return this.routingProfileId;
        }

        @Override
        public final Builder routingProfileId(String routingProfileId) {
            this.routingProfileId = routingProfileId;
            return this;
        }

        public final void setRoutingProfileId(String routingProfileId) {
            this.routingProfileId = routingProfileId;
        }

        public final Collection<RoutingProfileQueueReference.Builder> getQueueReferences() {
            if (this.queueReferences instanceof SdkAutoConstructList) {
                return null;
            }
            return this.queueReferences != null ? (Collection)this.queueReferences.stream().map(RoutingProfileQueueReference::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder queueReferences(Collection<RoutingProfileQueueReference> queueReferences) {
            this.queueReferences = RoutingProfileQueueReferenceListCopier.copy(queueReferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queueReferences(RoutingProfileQueueReference ... queueReferences) {
            this.queueReferences(Arrays.asList(queueReferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queueReferences(Consumer<RoutingProfileQueueReference.Builder> ... queueReferences) {
            this.queueReferences(Stream.of(queueReferences).map(c -> (RoutingProfileQueueReference)((RoutingProfileQueueReference.Builder)RoutingProfileQueueReference.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setQueueReferences(Collection<RoutingProfileQueueReference.BuilderImpl> queueReferences) {
            this.queueReferences = RoutingProfileQueueReferenceListCopier.copyFromBuilder(queueReferences);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateRoutingProfileQueuesRequest build() {
            return new DisassociateRoutingProfileQueuesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisassociateRoutingProfileQueuesRequest> {
        public Builder instanceId(String var1);

        public Builder routingProfileId(String var1);

        public Builder queueReferences(Collection<RoutingProfileQueueReference> var1);

        public Builder queueReferences(RoutingProfileQueueReference ... var1);

        public Builder queueReferences(Consumer<RoutingProfileQueueReference.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

