/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.UserSummary;
import software.amazon.awssdk.services.connect.model.UserSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListUsersResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, ListUsersResponse> {
    private static final SdkField<List<UserSummary>> USER_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserSummaryList").getter(ListUsersResponse.getter(ListUsersResponse::userSummaryList)).setter(ListUsersResponse.setter(Builder::userSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UserSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListUsersResponse.getter(ListUsersResponse::nextToken)).setter(ListUsersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<UserSummary> userSummaryList;
    private final String nextToken;

    private ListUsersResponse(BuilderImpl builder) {
        super(builder);
        this.userSummaryList = builder.userSummaryList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasUserSummaryList() {
        return this.userSummaryList != null && !(this.userSummaryList instanceof SdkAutoConstructList);
    }

    public final List<UserSummary> userSummaryList() {
        return this.userSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserSummaryList() ? this.userSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUsersResponse)) {
            return false;
        }
        ListUsersResponse other = (ListUsersResponse)((Object)obj);
        return this.hasUserSummaryList() == other.hasUserSummaryList() && Objects.equals(this.userSummaryList(), other.userSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListUsersResponse").add("UserSummaryList", this.hasUserSummaryList() ? this.userSummaryList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserSummaryList": {
                return Optional.ofNullable(clazz.cast(this.userSummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListUsersResponse, T> g) {
        return obj -> g.apply((ListUsersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<UserSummary> userSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUsersResponse model) {
            super(model);
            this.userSummaryList(model.userSummaryList);
            this.nextToken(model.nextToken);
        }

        public final List<UserSummary.Builder> getUserSummaryList() {
            List<UserSummary.Builder> result = UserSummaryListCopier.copyToBuilder(this.userSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder userSummaryList(Collection<UserSummary> userSummaryList) {
            this.userSummaryList = UserSummaryListCopier.copy(userSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userSummaryList(UserSummary ... userSummaryList) {
            this.userSummaryList(Arrays.asList(userSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userSummaryList(Consumer<UserSummary.Builder> ... userSummaryList) {
            this.userSummaryList(Stream.of(userSummaryList).map(c -> (UserSummary)((UserSummary.Builder)UserSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUserSummaryList(Collection<UserSummary.BuilderImpl> userSummaryList) {
            this.userSummaryList = UserSummaryListCopier.copyFromBuilder(userSummaryList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListUsersResponse build() {
            return new ListUsersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListUsersResponse> {
        public Builder userSummaryList(Collection<UserSummary> var1);

        public Builder userSummaryList(UserSummary ... var1);

        public Builder userSummaryList(Consumer<UserSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

