/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.model.ListSecurityKeysRequest;
import software.amazon.awssdk.services.connect.model.ListSecurityKeysResponse;
import software.amazon.awssdk.services.connect.model.SecurityKey;

public class ListSecurityKeysIterable
implements SdkIterable<ListSecurityKeysResponse> {
    private final ConnectClient client;
    private final ListSecurityKeysRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSecurityKeysIterable(ConnectClient client, ListSecurityKeysRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSecurityKeysResponseFetcher();
    }

    public Iterator<ListSecurityKeysResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SecurityKey> securityKeys() {
        Function<ListSecurityKeysResponse, Iterator> getIterator = response -> {
            if (response != null && response.securityKeys() != null) {
                return response.securityKeys().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSecurityKeysResponseFetcher
    implements SyncPageFetcher<ListSecurityKeysResponse> {
        private ListSecurityKeysResponseFetcher() {
        }

        public boolean hasNextPage(ListSecurityKeysResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSecurityKeysResponse nextPage(ListSecurityKeysResponse previousPage) {
            if (previousPage == null) {
                return ListSecurityKeysIterable.this.client.listSecurityKeys(ListSecurityKeysIterable.this.firstRequest);
            }
            return ListSecurityKeysIterable.this.client.listSecurityKeys((ListSecurityKeysRequest)((Object)ListSecurityKeysIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

