/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.QuickConnectSummary;
import software.amazon.awssdk.services.connect.model.QuickConnectSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListQuickConnectsResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, ListQuickConnectsResponse> {
    private static final SdkField<List<QuickConnectSummary>> QUICK_CONNECT_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("QuickConnectSummaryList").getter(ListQuickConnectsResponse.getter(ListQuickConnectsResponse::quickConnectSummaryList)).setter(ListQuickConnectsResponse.setter(Builder::quickConnectSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuickConnectSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(QuickConnectSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListQuickConnectsResponse.getter(ListQuickConnectsResponse::nextToken)).setter(ListQuickConnectsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUICK_CONNECT_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<QuickConnectSummary> quickConnectSummaryList;
    private final String nextToken;

    private ListQuickConnectsResponse(BuilderImpl builder) {
        super(builder);
        this.quickConnectSummaryList = builder.quickConnectSummaryList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasQuickConnectSummaryList() {
        return this.quickConnectSummaryList != null && !(this.quickConnectSummaryList instanceof SdkAutoConstructList);
    }

    public final List<QuickConnectSummary> quickConnectSummaryList() {
        return this.quickConnectSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQuickConnectSummaryList() ? this.quickConnectSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQuickConnectsResponse)) {
            return false;
        }
        ListQuickConnectsResponse other = (ListQuickConnectsResponse)((Object)obj);
        return this.hasQuickConnectSummaryList() == other.hasQuickConnectSummaryList() && Objects.equals(this.quickConnectSummaryList(), other.quickConnectSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListQuickConnectsResponse").add("QuickConnectSummaryList", this.hasQuickConnectSummaryList() ? this.quickConnectSummaryList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QuickConnectSummaryList": {
                return Optional.ofNullable(clazz.cast(this.quickConnectSummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListQuickConnectsResponse, T> g) {
        return obj -> g.apply((ListQuickConnectsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<QuickConnectSummary> quickConnectSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListQuickConnectsResponse model) {
            super(model);
            this.quickConnectSummaryList(model.quickConnectSummaryList);
            this.nextToken(model.nextToken);
        }

        public final List<QuickConnectSummary.Builder> getQuickConnectSummaryList() {
            List<QuickConnectSummary.Builder> result = QuickConnectSummaryListCopier.copyToBuilder(this.quickConnectSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder quickConnectSummaryList(Collection<QuickConnectSummary> quickConnectSummaryList) {
            this.quickConnectSummaryList = QuickConnectSummaryListCopier.copy(quickConnectSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder quickConnectSummaryList(QuickConnectSummary ... quickConnectSummaryList) {
            this.quickConnectSummaryList(Arrays.asList(quickConnectSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder quickConnectSummaryList(Consumer<QuickConnectSummary.Builder> ... quickConnectSummaryList) {
            this.quickConnectSummaryList(Stream.of(quickConnectSummaryList).map(c -> (QuickConnectSummary)((QuickConnectSummary.Builder)QuickConnectSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setQuickConnectSummaryList(Collection<QuickConnectSummary.BuilderImpl> quickConnectSummaryList) {
            this.quickConnectSummaryList = QuickConnectSummaryListCopier.copyFromBuilder(quickConnectSummaryList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListQuickConnectsResponse build() {
            return new ListQuickConnectsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListQuickConnectsResponse> {
        public Builder quickConnectSummaryList(Collection<QuickConnectSummary> var1);

        public Builder quickConnectSummaryList(QuickConnectSummary ... var1);

        public Builder quickConnectSummaryList(Consumer<QuickConnectSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

