/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a user account for a Amazon Connect instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class User implements SdkPojo, Serializable, ToCopyableBuilder<User.Builder, User> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(User::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(User::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Username").getter(getter(User::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()).build();

    private static final SdkField<UserIdentityInfo> IDENTITY_INFO_FIELD = SdkField
            .<UserIdentityInfo> builder(MarshallingType.SDK_POJO).memberName("IdentityInfo").getter(getter(User::identityInfo))
            .setter(setter(Builder::identityInfo)).constructor(UserIdentityInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityInfo").build()).build();

    private static final SdkField<UserPhoneConfig> PHONE_CONFIG_FIELD = SdkField
            .<UserPhoneConfig> builder(MarshallingType.SDK_POJO).memberName("PhoneConfig").getter(getter(User::phoneConfig))
            .setter(setter(Builder::phoneConfig)).constructor(UserPhoneConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneConfig").build()).build();

    private static final SdkField<String> DIRECTORY_USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryUserId").getter(getter(User::directoryUserId)).setter(setter(Builder::directoryUserId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryUserId").build()).build();

    private static final SdkField<List<String>> SECURITY_PROFILE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityProfileIds")
            .getter(getter(User::securityProfileIds))
            .setter(setter(Builder::securityProfileIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityProfileIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROUTING_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoutingProfileId").getter(getter(User::routingProfileId)).setter(setter(Builder::routingProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingProfileId").build()).build();

    private static final SdkField<String> HIERARCHY_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HierarchyGroupId").getter(getter(User::hierarchyGroupId)).setter(setter(Builder::hierarchyGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HierarchyGroupId").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(User::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            USERNAME_FIELD, IDENTITY_INFO_FIELD, PHONE_CONFIG_FIELD, DIRECTORY_USER_ID_FIELD, SECURITY_PROFILE_IDS_FIELD,
            ROUTING_PROFILE_ID_FIELD, HIERARCHY_GROUP_ID_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String username;

    private final UserIdentityInfo identityInfo;

    private final UserPhoneConfig phoneConfig;

    private final String directoryUserId;

    private final List<String> securityProfileIds;

    private final String routingProfileId;

    private final String hierarchyGroupId;

    private final Map<String, String> tags;

    private User(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.username = builder.username;
        this.identityInfo = builder.identityInfo;
        this.phoneConfig = builder.phoneConfig;
        this.directoryUserId = builder.directoryUserId;
        this.securityProfileIds = builder.securityProfileIds;
        this.routingProfileId = builder.routingProfileId;
        this.hierarchyGroupId = builder.hierarchyGroupId;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The identifier of the user account.
     * </p>
     * 
     * @return The identifier of the user account.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the user account.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the user account.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The user name assigned to the user account.
     * </p>
     * 
     * @return The user name assigned to the user account.
     */
    public final String username() {
        return username;
    }

    /**
     * <p>
     * Information about the user identity.
     * </p>
     * 
     * @return Information about the user identity.
     */
    public final UserIdentityInfo identityInfo() {
        return identityInfo;
    }

    /**
     * <p>
     * Information about the phone configuration for the user.
     * </p>
     * 
     * @return Information about the phone configuration for the user.
     */
    public final UserPhoneConfig phoneConfig() {
        return phoneConfig;
    }

    /**
     * <p>
     * The identifier of the user account in the directory used for identity management.
     * </p>
     * 
     * @return The identifier of the user account in the directory used for identity management.
     */
    public final String directoryUserId() {
        return directoryUserId;
    }

    /**
     * Returns true if the SecurityProfileIds property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSecurityProfileIds() {
        return securityProfileIds != null && !(securityProfileIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifiers of the security profiles for the user.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecurityProfileIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The identifiers of the security profiles for the user.
     */
    public final List<String> securityProfileIds() {
        return securityProfileIds;
    }

    /**
     * <p>
     * The identifier of the routing profile for the user.
     * </p>
     * 
     * @return The identifier of the routing profile for the user.
     */
    public final String routingProfileId() {
        return routingProfileId;
    }

    /**
     * <p>
     * The identifier of the hierarchy group for the user.
     * </p>
     * 
     * @return The identifier of the hierarchy group for the user.
     */
    public final String hierarchyGroupId() {
        return hierarchyGroupId;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(identityInfo());
        hashCode = 31 * hashCode + Objects.hashCode(phoneConfig());
        hashCode = 31 * hashCode + Objects.hashCode(directoryUserId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityProfileIds() ? securityProfileIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(routingProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(hierarchyGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof User)) {
            return false;
        }
        User other = (User) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(username(), other.username()) && Objects.equals(identityInfo(), other.identityInfo())
                && Objects.equals(phoneConfig(), other.phoneConfig())
                && Objects.equals(directoryUserId(), other.directoryUserId())
                && hasSecurityProfileIds() == other.hasSecurityProfileIds()
                && Objects.equals(securityProfileIds(), other.securityProfileIds())
                && Objects.equals(routingProfileId(), other.routingProfileId())
                && Objects.equals(hierarchyGroupId(), other.hierarchyGroupId()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("User").add("Id", id()).add("Arn", arn()).add("Username", username())
                .add("IdentityInfo", identityInfo()).add("PhoneConfig", phoneConfig()).add("DirectoryUserId", directoryUserId())
                .add("SecurityProfileIds", hasSecurityProfileIds() ? securityProfileIds() : null)
                .add("RoutingProfileId", routingProfileId()).add("HierarchyGroupId", hierarchyGroupId())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        case "IdentityInfo":
            return Optional.ofNullable(clazz.cast(identityInfo()));
        case "PhoneConfig":
            return Optional.ofNullable(clazz.cast(phoneConfig()));
        case "DirectoryUserId":
            return Optional.ofNullable(clazz.cast(directoryUserId()));
        case "SecurityProfileIds":
            return Optional.ofNullable(clazz.cast(securityProfileIds()));
        case "RoutingProfileId":
            return Optional.ofNullable(clazz.cast(routingProfileId()));
        case "HierarchyGroupId":
            return Optional.ofNullable(clazz.cast(hierarchyGroupId()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<User, T> g) {
        return obj -> g.apply((User) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, User> {
        /**
         * <p>
         * The identifier of the user account.
         * </p>
         * 
         * @param id
         *        The identifier of the user account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the user account.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the user account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The user name assigned to the user account.
         * </p>
         * 
         * @param username
         *        The user name assigned to the user account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * Information about the user identity.
         * </p>
         * 
         * @param identityInfo
         *        Information about the user identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityInfo(UserIdentityInfo identityInfo);

        /**
         * <p>
         * Information about the user identity.
         * </p>
         * This is a convenience that creates an instance of the {@link UserIdentityInfo.Builder} avoiding the need to
         * create one manually via {@link UserIdentityInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserIdentityInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #identityInfo(UserIdentityInfo)}.
         * 
         * @param identityInfo
         *        a consumer that will call methods on {@link UserIdentityInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identityInfo(UserIdentityInfo)
         */
        default Builder identityInfo(Consumer<UserIdentityInfo.Builder> identityInfo) {
            return identityInfo(UserIdentityInfo.builder().applyMutation(identityInfo).build());
        }

        /**
         * <p>
         * Information about the phone configuration for the user.
         * </p>
         * 
         * @param phoneConfig
         *        Information about the phone configuration for the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneConfig(UserPhoneConfig phoneConfig);

        /**
         * <p>
         * Information about the phone configuration for the user.
         * </p>
         * This is a convenience that creates an instance of the {@link UserPhoneConfig.Builder} avoiding the need to
         * create one manually via {@link UserPhoneConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserPhoneConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #phoneConfig(UserPhoneConfig)}.
         * 
         * @param phoneConfig
         *        a consumer that will call methods on {@link UserPhoneConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #phoneConfig(UserPhoneConfig)
         */
        default Builder phoneConfig(Consumer<UserPhoneConfig.Builder> phoneConfig) {
            return phoneConfig(UserPhoneConfig.builder().applyMutation(phoneConfig).build());
        }

        /**
         * <p>
         * The identifier of the user account in the directory used for identity management.
         * </p>
         * 
         * @param directoryUserId
         *        The identifier of the user account in the directory used for identity management.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryUserId(String directoryUserId);

        /**
         * <p>
         * The identifiers of the security profiles for the user.
         * </p>
         * 
         * @param securityProfileIds
         *        The identifiers of the security profiles for the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityProfileIds(Collection<String> securityProfileIds);

        /**
         * <p>
         * The identifiers of the security profiles for the user.
         * </p>
         * 
         * @param securityProfileIds
         *        The identifiers of the security profiles for the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityProfileIds(String... securityProfileIds);

        /**
         * <p>
         * The identifier of the routing profile for the user.
         * </p>
         * 
         * @param routingProfileId
         *        The identifier of the routing profile for the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingProfileId(String routingProfileId);

        /**
         * <p>
         * The identifier of the hierarchy group for the user.
         * </p>
         * 
         * @param hierarchyGroupId
         *        The identifier of the hierarchy group for the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hierarchyGroupId(String hierarchyGroupId);

        /**
         * <p>
         * The tags.
         * </p>
         * 
         * @param tags
         *        The tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String username;

        private UserIdentityInfo identityInfo;

        private UserPhoneConfig phoneConfig;

        private String directoryUserId;

        private List<String> securityProfileIds = DefaultSdkAutoConstructList.getInstance();

        private String routingProfileId;

        private String hierarchyGroupId;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(User model) {
            id(model.id);
            arn(model.arn);
            username(model.username);
            identityInfo(model.identityInfo);
            phoneConfig(model.phoneConfig);
            directoryUserId(model.directoryUserId);
            securityProfileIds(model.securityProfileIds);
            routingProfileId(model.routingProfileId);
            hierarchyGroupId(model.hierarchyGroupId);
            tags(model.tags);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getUsername() {
            return username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final UserIdentityInfo.Builder getIdentityInfo() {
            return identityInfo != null ? identityInfo.toBuilder() : null;
        }

        @Override
        public final Builder identityInfo(UserIdentityInfo identityInfo) {
            this.identityInfo = identityInfo;
            return this;
        }

        public final void setIdentityInfo(UserIdentityInfo.BuilderImpl identityInfo) {
            this.identityInfo = identityInfo != null ? identityInfo.build() : null;
        }

        public final UserPhoneConfig.Builder getPhoneConfig() {
            return phoneConfig != null ? phoneConfig.toBuilder() : null;
        }

        @Override
        public final Builder phoneConfig(UserPhoneConfig phoneConfig) {
            this.phoneConfig = phoneConfig;
            return this;
        }

        public final void setPhoneConfig(UserPhoneConfig.BuilderImpl phoneConfig) {
            this.phoneConfig = phoneConfig != null ? phoneConfig.build() : null;
        }

        public final String getDirectoryUserId() {
            return directoryUserId;
        }

        @Override
        public final Builder directoryUserId(String directoryUserId) {
            this.directoryUserId = directoryUserId;
            return this;
        }

        public final void setDirectoryUserId(String directoryUserId) {
            this.directoryUserId = directoryUserId;
        }

        public final Collection<String> getSecurityProfileIds() {
            if (securityProfileIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityProfileIds;
        }

        @Override
        public final Builder securityProfileIds(Collection<String> securityProfileIds) {
            this.securityProfileIds = SecurityProfileIdsCopier.copy(securityProfileIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityProfileIds(String... securityProfileIds) {
            securityProfileIds(Arrays.asList(securityProfileIds));
            return this;
        }

        public final void setSecurityProfileIds(Collection<String> securityProfileIds) {
            this.securityProfileIds = SecurityProfileIdsCopier.copy(securityProfileIds);
        }

        public final String getRoutingProfileId() {
            return routingProfileId;
        }

        @Override
        public final Builder routingProfileId(String routingProfileId) {
            this.routingProfileId = routingProfileId;
            return this;
        }

        public final void setRoutingProfileId(String routingProfileId) {
            this.routingProfileId = routingProfileId;
        }

        public final String getHierarchyGroupId() {
            return hierarchyGroupId;
        }

        @Override
        public final Builder hierarchyGroupId(String hierarchyGroupId) {
            this.hierarchyGroupId = hierarchyGroupId;
            return this;
        }

        public final void setHierarchyGroupId(String hierarchyGroupId) {
            this.hierarchyGroupId = hierarchyGroupId;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public User build() {
            return new User(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
