/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the Amazon Simple Storage Service (Amazon S3) storage type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3Config implements SdkPojo, Serializable, ToCopyableBuilder<S3Config.Builder, S3Config> {
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BucketName").getter(getter(S3Config::bucketName)).setter(setter(Builder::bucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketName").build()).build();

    private static final SdkField<String> BUCKET_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BucketPrefix").getter(getter(S3Config::bucketPrefix)).setter(setter(Builder::bucketPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketPrefix").build()).build();

    private static final SdkField<EncryptionConfig> ENCRYPTION_CONFIG_FIELD = SdkField
            .<EncryptionConfig> builder(MarshallingType.SDK_POJO).memberName("EncryptionConfig")
            .getter(getter(S3Config::encryptionConfig)).setter(setter(Builder::encryptionConfig))
            .constructor(EncryptionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_NAME_FIELD,
            BUCKET_PREFIX_FIELD, ENCRYPTION_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bucketName;

    private final String bucketPrefix;

    private final EncryptionConfig encryptionConfig;

    private S3Config(BuilderImpl builder) {
        this.bucketName = builder.bucketName;
        this.bucketPrefix = builder.bucketPrefix;
        this.encryptionConfig = builder.encryptionConfig;
    }

    /**
     * <p>
     * The S3 bucket name.
     * </p>
     * 
     * @return The S3 bucket name.
     */
    public final String bucketName() {
        return bucketName;
    }

    /**
     * <p>
     * The S3 bucket prefix.
     * </p>
     * 
     * @return The S3 bucket prefix.
     */
    public final String bucketPrefix() {
        return bucketPrefix;
    }

    /**
     * <p>
     * The Amazon S3 encryption configuration.
     * </p>
     * 
     * @return The Amazon S3 encryption configuration.
     */
    public final EncryptionConfig encryptionConfig() {
        return encryptionConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(bucketPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Config)) {
            return false;
        }
        S3Config other = (S3Config) obj;
        return Objects.equals(bucketName(), other.bucketName()) && Objects.equals(bucketPrefix(), other.bucketPrefix())
                && Objects.equals(encryptionConfig(), other.encryptionConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3Config").add("BucketName", bucketName()).add("BucketPrefix", bucketPrefix())
                .add("EncryptionConfig", encryptionConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BucketName":
            return Optional.ofNullable(clazz.cast(bucketName()));
        case "BucketPrefix":
            return Optional.ofNullable(clazz.cast(bucketPrefix()));
        case "EncryptionConfig":
            return Optional.ofNullable(clazz.cast(encryptionConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3Config, T> g) {
        return obj -> g.apply((S3Config) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3Config> {
        /**
         * <p>
         * The S3 bucket name.
         * </p>
         * 
         * @param bucketName
         *        The S3 bucket name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketName(String bucketName);

        /**
         * <p>
         * The S3 bucket prefix.
         * </p>
         * 
         * @param bucketPrefix
         *        The S3 bucket prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketPrefix(String bucketPrefix);

        /**
         * <p>
         * The Amazon S3 encryption configuration.
         * </p>
         * 
         * @param encryptionConfig
         *        The Amazon S3 encryption configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfig(EncryptionConfig encryptionConfig);

        /**
         * <p>
         * The Amazon S3 encryption configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link EncryptionConfig.Builder} avoiding the need to
         * create one manually via {@link EncryptionConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link EncryptionConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #encryptionConfig(EncryptionConfig)}.
         * 
         * @param encryptionConfig
         *        a consumer that will call methods on {@link EncryptionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionConfig(EncryptionConfig)
         */
        default Builder encryptionConfig(Consumer<EncryptionConfig.Builder> encryptionConfig) {
            return encryptionConfig(EncryptionConfig.builder().applyMutation(encryptionConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String bucketName;

        private String bucketPrefix;

        private EncryptionConfig encryptionConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Config model) {
            bucketName(model.bucketName);
            bucketPrefix(model.bucketPrefix);
            encryptionConfig(model.encryptionConfig);
        }

        public final String getBucketName() {
            return bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public final String getBucketPrefix() {
            return bucketPrefix;
        }

        @Override
        public final Builder bucketPrefix(String bucketPrefix) {
            this.bucketPrefix = bucketPrefix;
            return this;
        }

        public final void setBucketPrefix(String bucketPrefix) {
            this.bucketPrefix = bucketPrefix;
        }

        public final EncryptionConfig.Builder getEncryptionConfig() {
            return encryptionConfig != null ? encryptionConfig.toBuilder() : null;
        }

        @Override
        public final Builder encryptionConfig(EncryptionConfig encryptionConfig) {
            this.encryptionConfig = encryptionConfig;
            return this;
        }

        public final void setEncryptionConfig(EncryptionConfig.BuilderImpl encryptionConfig) {
            this.encryptionConfig = encryptionConfig != null ? encryptionConfig.build() : null;
        }

        @Override
        public S3Config build() {
            return new S3Config(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
