/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about which channels are supported, and how many contacts an agent can have on a channel
 * simultaneously.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MediaConcurrency implements SdkPojo, Serializable,
        ToCopyableBuilder<MediaConcurrency.Builder, MediaConcurrency> {
    private static final SdkField<String> CHANNEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Channel")
            .getter(getter(MediaConcurrency::channelAsString)).setter(setter(Builder::channel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Channel").build()).build();

    private static final SdkField<Integer> CONCURRENCY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Concurrency").getter(getter(MediaConcurrency::concurrency)).setter(setter(Builder::concurrency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Concurrency").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_FIELD,
            CONCURRENCY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String channel;

    private final Integer concurrency;

    private MediaConcurrency(BuilderImpl builder) {
        this.channel = builder.channel;
        this.concurrency = builder.concurrency;
    }

    /**
     * <p>
     * The channels that agents can handle in the Contact Control Panel (CCP).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channel} will
     * return {@link Channel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelAsString}.
     * </p>
     * 
     * @return The channels that agents can handle in the Contact Control Panel (CCP).
     * @see Channel
     */
    public final Channel channel() {
        return Channel.fromValue(channel);
    }

    /**
     * <p>
     * The channels that agents can handle in the Contact Control Panel (CCP).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channel} will
     * return {@link Channel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelAsString}.
     * </p>
     * 
     * @return The channels that agents can handle in the Contact Control Panel (CCP).
     * @see Channel
     */
    public final String channelAsString() {
        return channel;
    }

    /**
     * <p>
     * The number of contacts an agent can have on a channel simultaneously.
     * </p>
     * 
     * @return The number of contacts an agent can have on a channel simultaneously.
     */
    public final Integer concurrency() {
        return concurrency;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(channelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(concurrency());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaConcurrency)) {
            return false;
        }
        MediaConcurrency other = (MediaConcurrency) obj;
        return Objects.equals(channelAsString(), other.channelAsString()) && Objects.equals(concurrency(), other.concurrency());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MediaConcurrency").add("Channel", channelAsString()).add("Concurrency", concurrency()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Channel":
            return Optional.ofNullable(clazz.cast(channelAsString()));
        case "Concurrency":
            return Optional.ofNullable(clazz.cast(concurrency()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MediaConcurrency, T> g) {
        return obj -> g.apply((MediaConcurrency) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MediaConcurrency> {
        /**
         * <p>
         * The channels that agents can handle in the Contact Control Panel (CCP).
         * </p>
         * 
         * @param channel
         *        The channels that agents can handle in the Contact Control Panel (CCP).
         * @see Channel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Channel
         */
        Builder channel(String channel);

        /**
         * <p>
         * The channels that agents can handle in the Contact Control Panel (CCP).
         * </p>
         * 
         * @param channel
         *        The channels that agents can handle in the Contact Control Panel (CCP).
         * @see Channel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Channel
         */
        Builder channel(Channel channel);

        /**
         * <p>
         * The number of contacts an agent can have on a channel simultaneously.
         * </p>
         * 
         * @param concurrency
         *        The number of contacts an agent can have on a channel simultaneously.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder concurrency(Integer concurrency);
    }

    static final class BuilderImpl implements Builder {
        private String channel;

        private Integer concurrency;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaConcurrency model) {
            channel(model.channel);
            concurrency(model.concurrency);
        }

        public final String getChannel() {
            return channel;
        }

        @Override
        public final Builder channel(String channel) {
            this.channel = channel;
            return this;
        }

        @Override
        public final Builder channel(Channel channel) {
            this.channel(channel == null ? null : channel.toString());
            return this;
        }

        public final void setChannel(String channel) {
            this.channel = channel;
        }

        public final Integer getConcurrency() {
            return concurrency;
        }

        @Override
        public final Builder concurrency(Integer concurrency) {
            this.concurrency = concurrency;
            return this;
        }

        public final void setConcurrency(Integer concurrency) {
            this.concurrency = concurrency;
        }

        @Override
        public MediaConcurrency build() {
            return new MediaConcurrency(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
