/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMetricDataResponse extends ConnectResponse implements
        ToCopyableBuilder<GetMetricDataResponse.Builder, GetMetricDataResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetMetricDataResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<HistoricalMetricResult>> METRIC_RESULTS_FIELD = SdkField
            .<List<HistoricalMetricResult>> builder(MarshallingType.LIST)
            .memberName("MetricResults")
            .getter(getter(GetMetricDataResponse::metricResults))
            .setter(setter(Builder::metricResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricResults").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HistoricalMetricResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(HistoricalMetricResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            METRIC_RESULTS_FIELD));

    private final String nextToken;

    private final List<HistoricalMetricResult> metricResults;

    private GetMetricDataResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.metricResults = builder.metricResults;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * <p>
     * The token expires after 5 minutes from the time it is created. Subsequent requests that use the token must use
     * the same request parameters as the request that generated the token.
     * </p>
     * 
     * @return If there are additional results, this is the token for the next set of results.</p>
     *         <p>
     *         The token expires after 5 minutes from the time it is created. Subsequent requests that use the token
     *         must use the same request parameters as the request that generated the token.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the MetricResults property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasMetricResults() {
        return metricResults != null && !(metricResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the historical metrics.
     * </p>
     * <p>
     * If no grouping is specified, a summary of metric data is returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMetricResults()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the historical metrics.</p>
     *         <p>
     *         If no grouping is specified, a summary of metric data is returned.
     */
    public final List<HistoricalMetricResult> metricResults() {
        return metricResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricResults() ? metricResults() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMetricDataResponse)) {
            return false;
        }
        GetMetricDataResponse other = (GetMetricDataResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasMetricResults() == other.hasMetricResults()
                && Objects.equals(metricResults(), other.metricResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMetricDataResponse").add("NextToken", nextToken())
                .add("MetricResults", hasMetricResults() ? metricResults() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MetricResults":
            return Optional.ofNullable(clazz.cast(metricResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMetricDataResponse, T> g) {
        return obj -> g.apply((GetMetricDataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetMetricDataResponse> {
        /**
         * <p>
         * If there are additional results, this is the token for the next set of results.
         * </p>
         * <p>
         * The token expires after 5 minutes from the time it is created. Subsequent requests that use the token must
         * use the same request parameters as the request that generated the token.
         * </p>
         * 
         * @param nextToken
         *        If there are additional results, this is the token for the next set of results.</p>
         *        <p>
         *        The token expires after 5 minutes from the time it is created. Subsequent requests that use the token
         *        must use the same request parameters as the request that generated the token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Information about the historical metrics.
         * </p>
         * <p>
         * If no grouping is specified, a summary of metric data is returned.
         * </p>
         * 
         * @param metricResults
         *        Information about the historical metrics.</p>
         *        <p>
         *        If no grouping is specified, a summary of metric data is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricResults(Collection<HistoricalMetricResult> metricResults);

        /**
         * <p>
         * Information about the historical metrics.
         * </p>
         * <p>
         * If no grouping is specified, a summary of metric data is returned.
         * </p>
         * 
         * @param metricResults
         *        Information about the historical metrics.</p>
         *        <p>
         *        If no grouping is specified, a summary of metric data is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricResults(HistoricalMetricResult... metricResults);

        /**
         * <p>
         * Information about the historical metrics.
         * </p>
         * <p>
         * If no grouping is specified, a summary of metric data is returned.
         * </p>
         * This is a convenience that creates an instance of the {@link List<HistoricalMetricResult>.Builder} avoiding
         * the need to create one manually via {@link List<HistoricalMetricResult>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<HistoricalMetricResult>.Builder#build()} is called
         * immediately and its result is passed to {@link #metricResults(List<HistoricalMetricResult>)}.
         * 
         * @param metricResults
         *        a consumer that will call methods on {@link List<HistoricalMetricResult>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricResults(List<HistoricalMetricResult>)
         */
        Builder metricResults(Consumer<HistoricalMetricResult.Builder>... metricResults);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<HistoricalMetricResult> metricResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetMetricDataResponse model) {
            super(model);
            nextToken(model.nextToken);
            metricResults(model.metricResults);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<HistoricalMetricResult.Builder> getMetricResults() {
            if (metricResults instanceof SdkAutoConstructList) {
                return null;
            }
            return metricResults != null ? metricResults.stream().map(HistoricalMetricResult::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder metricResults(Collection<HistoricalMetricResult> metricResults) {
            this.metricResults = HistoricalMetricResultsCopier.copy(metricResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricResults(HistoricalMetricResult... metricResults) {
            metricResults(Arrays.asList(metricResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricResults(Consumer<HistoricalMetricResult.Builder>... metricResults) {
            metricResults(Stream.of(metricResults).map(c -> HistoricalMetricResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setMetricResults(Collection<HistoricalMetricResult.BuilderImpl> metricResults) {
            this.metricResults = HistoricalMetricResultsCopier.copyFromBuilder(metricResults);
        }

        @Override
        public GetMetricDataResponse build() {
            return new GetMetricDataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
