/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateUseCaseResponse extends ConnectResponse implements
        ToCopyableBuilder<CreateUseCaseResponse.Builder, CreateUseCaseResponse> {
    private static final SdkField<String> USE_CASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UseCaseId").getter(getter(CreateUseCaseResponse::useCaseId)).setter(setter(Builder::useCaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseCaseId").build()).build();

    private static final SdkField<String> USE_CASE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UseCaseArn").getter(getter(CreateUseCaseResponse::useCaseArn)).setter(setter(Builder::useCaseArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseCaseArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USE_CASE_ID_FIELD,
            USE_CASE_ARN_FIELD));

    private final String useCaseId;

    private final String useCaseArn;

    private CreateUseCaseResponse(BuilderImpl builder) {
        super(builder);
        this.useCaseId = builder.useCaseId;
        this.useCaseArn = builder.useCaseArn;
    }

    /**
     * <p>
     * The identifier of the use case.
     * </p>
     * 
     * @return The identifier of the use case.
     */
    public final String useCaseId() {
        return useCaseId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the use case.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the use case.
     */
    public final String useCaseArn() {
        return useCaseArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(useCaseId());
        hashCode = 31 * hashCode + Objects.hashCode(useCaseArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUseCaseResponse)) {
            return false;
        }
        CreateUseCaseResponse other = (CreateUseCaseResponse) obj;
        return Objects.equals(useCaseId(), other.useCaseId()) && Objects.equals(useCaseArn(), other.useCaseArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateUseCaseResponse").add("UseCaseId", useCaseId()).add("UseCaseArn", useCaseArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UseCaseId":
            return Optional.ofNullable(clazz.cast(useCaseId()));
        case "UseCaseArn":
            return Optional.ofNullable(clazz.cast(useCaseArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateUseCaseResponse, T> g) {
        return obj -> g.apply((CreateUseCaseResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateUseCaseResponse> {
        /**
         * <p>
         * The identifier of the use case.
         * </p>
         * 
         * @param useCaseId
         *        The identifier of the use case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useCaseId(String useCaseId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the use case.
         * </p>
         * 
         * @param useCaseArn
         *        The Amazon Resource Name (ARN) for the use case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useCaseArn(String useCaseArn);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private String useCaseId;

        private String useCaseArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUseCaseResponse model) {
            super(model);
            useCaseId(model.useCaseId);
            useCaseArn(model.useCaseArn);
        }

        public final String getUseCaseId() {
            return useCaseId;
        }

        @Override
        public final Builder useCaseId(String useCaseId) {
            this.useCaseId = useCaseId;
            return this;
        }

        public final void setUseCaseId(String useCaseId) {
            this.useCaseId = useCaseId;
        }

        public final String getUseCaseArn() {
            return useCaseArn;
        }

        @Override
        public final Builder useCaseArn(String useCaseArn) {
            this.useCaseArn = useCaseArn;
            return this;
        }

        public final void setUseCaseArn(String useCaseArn) {
            this.useCaseArn = useCaseArn;
        }

        @Override
        public CreateUseCaseResponse build() {
            return new CreateUseCaseResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
