/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum InstanceAttributeType {
    INBOUND_CALLS("INBOUND_CALLS"),
    OUTBOUND_CALLS("OUTBOUND_CALLS"),
    CONTACTFLOW_LOGS("CONTACTFLOW_LOGS"),
    CONTACT_LENS("CONTACT_LENS"),
    AUTO_RESOLVE_BEST_VOICES("AUTO_RESOLVE_BEST_VOICES"),
    USE_CUSTOM_TTS_VOICES("USE_CUSTOM_TTS_VOICES"),
    EARLY_MEDIA("EARLY_MEDIA"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private InstanceAttributeType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InstanceAttributeType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(InstanceAttributeType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InstanceAttributeType> knownValues() {
        return Stream.of(InstanceAttributeType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

