/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.PhoneNumberSummary;
import software.amazon.awssdk.services.connect.model.PhoneNumberSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPhoneNumbersResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, ListPhoneNumbersResponse> {
    private static final SdkField<List<PhoneNumberSummary>> PHONE_NUMBER_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PhoneNumberSummaryList").getter(ListPhoneNumbersResponse.getter(ListPhoneNumbersResponse::phoneNumberSummaryList)).setter(ListPhoneNumbersResponse.setter(Builder::phoneNumberSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PhoneNumberSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListPhoneNumbersResponse.getter(ListPhoneNumbersResponse::nextToken)).setter(ListPhoneNumbersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_NUMBER_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<PhoneNumberSummary> phoneNumberSummaryList;
    private final String nextToken;

    private ListPhoneNumbersResponse(BuilderImpl builder) {
        super(builder);
        this.phoneNumberSummaryList = builder.phoneNumberSummaryList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPhoneNumberSummaryList() {
        return this.phoneNumberSummaryList != null && !(this.phoneNumberSummaryList instanceof SdkAutoConstructList);
    }

    public final List<PhoneNumberSummary> phoneNumberSummaryList() {
        return this.phoneNumberSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPhoneNumberSummaryList() ? this.phoneNumberSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPhoneNumbersResponse)) {
            return false;
        }
        ListPhoneNumbersResponse other = (ListPhoneNumbersResponse)((Object)obj);
        return this.hasPhoneNumberSummaryList() == other.hasPhoneNumberSummaryList() && Objects.equals(this.phoneNumberSummaryList(), other.phoneNumberSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPhoneNumbersResponse").add("PhoneNumberSummaryList", this.hasPhoneNumberSummaryList() ? this.phoneNumberSummaryList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PhoneNumberSummaryList": {
                return Optional.ofNullable(clazz.cast(this.phoneNumberSummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPhoneNumbersResponse, T> g) {
        return obj -> g.apply((ListPhoneNumbersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<PhoneNumberSummary> phoneNumberSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPhoneNumbersResponse model) {
            super(model);
            this.phoneNumberSummaryList(model.phoneNumberSummaryList);
            this.nextToken(model.nextToken);
        }

        public final Collection<PhoneNumberSummary.Builder> getPhoneNumberSummaryList() {
            if (this.phoneNumberSummaryList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.phoneNumberSummaryList != null ? (Collection)this.phoneNumberSummaryList.stream().map(PhoneNumberSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder phoneNumberSummaryList(Collection<PhoneNumberSummary> phoneNumberSummaryList) {
            this.phoneNumberSummaryList = PhoneNumberSummaryListCopier.copy(phoneNumberSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumberSummaryList(PhoneNumberSummary ... phoneNumberSummaryList) {
            this.phoneNumberSummaryList(Arrays.asList(phoneNumberSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumberSummaryList(Consumer<PhoneNumberSummary.Builder> ... phoneNumberSummaryList) {
            this.phoneNumberSummaryList(Stream.of(phoneNumberSummaryList).map(c -> (PhoneNumberSummary)((PhoneNumberSummary.Builder)PhoneNumberSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPhoneNumberSummaryList(Collection<PhoneNumberSummary.BuilderImpl> phoneNumberSummaryList) {
            this.phoneNumberSummaryList = PhoneNumberSummaryListCopier.copyFromBuilder(phoneNumberSummaryList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListPhoneNumbersResponse build() {
            return new ListPhoneNumbersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPhoneNumbersResponse> {
        public Builder phoneNumberSummaryList(Collection<PhoneNumberSummary> var1);

        public Builder phoneNumberSummaryList(PhoneNumberSummary ... var1);

        public Builder phoneNumberSummaryList(Consumer<PhoneNumberSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

